/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionRegLoad;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionRegLoadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.load.grouping.NxActionRegLoadBuilder;

public class RegLoadCodec
extends AbstractActionCodec {
    public static final int LENGTH = 24;
    public static final byte SUBTYPE = 7;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionRegLoad.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 7);

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionRegLoad actionRegLoad = (ActionRegLoad)input.getActionChoice();
        RegLoadCodec.serializeHeader(24, 7, outBuffer);
        outBuffer.writeShort(actionRegLoad.getNxActionRegLoad().getOfsNbits().intValue());
        outBuffer.writeInt(actionRegLoad.getNxActionRegLoad().getDst().intValue());
        outBuffer.writeLong(actionRegLoad.getNxActionRegLoad().getValue().longValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = RegLoadCodec.deserializeHeader(message);
        NxActionRegLoadBuilder nxActionRegLoadBuilder = new NxActionRegLoadBuilder();
        ActionRegLoadBuilder actionRegLoadBuilder = new ActionRegLoadBuilder();
        nxActionRegLoadBuilder.setOfsNbits(message.readUnsignedShort());
        nxActionRegLoadBuilder.setDst(message.readUnsignedInt());
        nxActionRegLoadBuilder.setValue(BigInteger.valueOf(message.readLong()));
        actionRegLoadBuilder.setNxActionRegLoad(nxActionRegLoadBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)actionRegLoadBuilder.build());
        return actionBuilder.build();
    }
}

