/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionOutputReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionOutputRegBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.output.reg.grouping.NxActionOutputRegBuilder;

public class OutputRegCodec
extends AbstractActionCodec {
    public static final int LENGTH = 24;
    public static final byte SUBTYPE = 15;
    public static final byte PADDING_IN_OUTPUT_REG_ACTION = 6;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionOutputReg.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 15);

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionOutputReg action = (ActionOutputReg)input.getActionChoice();
        OutputRegCodec.serializeHeader(24, 15, outBuffer);
        outBuffer.writeShort((int)action.getNxActionOutputReg().getNBits().shortValue());
        outBuffer.writeInt(action.getNxActionOutputReg().getSrc().intValue());
        outBuffer.writeShort((int)action.getNxActionOutputReg().getMaxLen().shortValue());
        outBuffer.writeZero(6);
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = OutputRegCodec.deserializeHeader(message);
        ActionOutputRegBuilder builder = new ActionOutputRegBuilder();
        NxActionOutputRegBuilder nxActionOutputRegBuilder = new NxActionOutputRegBuilder();
        nxActionOutputRegBuilder.setNBits(message.readUnsignedShort());
        nxActionOutputRegBuilder.setSrc(message.readUnsignedInt());
        nxActionOutputRegBuilder.setMaxLen(message.readUnsignedShort());
        message.skipBytes(6);
        builder.setNxActionOutputReg(nxActionOutputRegBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

