/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionMultipathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.multipath.grouping.NxActionMultipathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipathCodec
extends AbstractActionCodec {
    private static final Logger logger = LoggerFactory.getLogger(MultipathCodec.class);
    public static final int LENGTH = 32;
    public static final byte NXAST_MULTIPATH_SUBTYPE = 10;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionMultipath.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 10);

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionMultipath action = (ActionMultipath)input.getActionChoice();
        MultipathCodec.serializeHeader(32, 10, outBuffer);
        outBuffer.writeShort(action.getNxActionMultipath().getFields().getIntValue());
        outBuffer.writeShort((int)action.getNxActionMultipath().getBasis().shortValue());
        outBuffer.writeZero(2);
        outBuffer.writeShort(action.getNxActionMultipath().getAlgorithm().getIntValue());
        outBuffer.writeShort((int)action.getNxActionMultipath().getMaxLink().shortValue());
        outBuffer.writeInt(action.getNxActionMultipath().getArg().intValue());
        outBuffer.writeZero(2);
        outBuffer.writeShort((int)action.getNxActionMultipath().getOfsNbits().shortValue());
        outBuffer.writeInt(action.getNxActionMultipath().getDst().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = MultipathCodec.deserializeHeader(message);
        ActionMultipathBuilder actionMultipathBuilder = new ActionMultipathBuilder();
        NxActionMultipathBuilder nxActionMultipathBuilder = new NxActionMultipathBuilder();
        nxActionMultipathBuilder.setFields(OfjNxHashFields.forValue(message.readUnsignedShort()));
        nxActionMultipathBuilder.setBasis(message.readUnsignedShort());
        message.skipBytes(2);
        nxActionMultipathBuilder.setAlgorithm(OfjNxMpAlgorithm.forValue(message.readUnsignedShort()));
        nxActionMultipathBuilder.setMaxLink(message.readUnsignedShort());
        nxActionMultipathBuilder.setArg(message.readUnsignedInt());
        message.skipBytes(2);
        nxActionMultipathBuilder.setOfsNbits(message.readUnsignedShort());
        nxActionMultipathBuilder.setDst(message.readUnsignedInt());
        actionMultipathBuilder.setNxActionMultipath(nxActionMultipathBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)actionMultipathBuilder.build());
        return actionBuilder.build();
    }
}

