/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionConntrackBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.NxActionConntrackBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConntrackCodec
extends AbstractActionCodec {
    private static final Logger logger = LoggerFactory.getLogger(ConntrackCodec.class);
    public static final int LENGTH = 24;
    public static final byte NXAST_CONNTRACK_SUBTYPE = 35;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionConntrack.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 35);

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionConntrack action = (ActionConntrack)input.getActionChoice();
        ConntrackCodec.serializeHeader(24, 35, outBuffer);
        outBuffer.writeShort((int)action.getNxActionConntrack().getFlags().shortValue());
        outBuffer.writeInt(action.getNxActionConntrack().getZoneSrc().intValue());
        outBuffer.writeShort((int)action.getNxActionConntrack().getConntrackZone().shortValue());
        outBuffer.writeByte((int)action.getNxActionConntrack().getRecircTable().byteValue());
        outBuffer.writeZero(5);
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = ConntrackCodec.deserializeHeader(message);
        ActionConntrackBuilder actionConntrackBuilder = new ActionConntrackBuilder();
        NxActionConntrackBuilder nxActionConntrackBuilder = new NxActionConntrackBuilder();
        nxActionConntrackBuilder.setFlags(message.readUnsignedShort());
        nxActionConntrackBuilder.setZoneSrc(message.readUnsignedInt());
        nxActionConntrackBuilder.setConntrackZone(message.readUnsignedShort());
        nxActionConntrackBuilder.setRecircTable(message.readUnsignedByte());
        message.skipBytes(5);
        actionConntrackBuilder.setNxActionConntrack(nxActionConntrackBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)actionConntrackBuilder.build());
        return actionBuilder.build();
    }
}

