/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import java.util.Arrays;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public abstract class PacketUtils {
    private static final int MAC_ADDRESS_SIZE = 6;
    private static final int DST_MAC_START_POSITION = 0;
    private static final int DST_MAC_END_POSITION = 6;
    private static final int SRC_MAC_START_POSITION = 6;
    private static final int SRC_MAC_END_POSITION = 12;
    private static final int ETHER_TYPE_START_POSITION = 12;
    private static final int ETHER_TYPE_END_POSITION = 14;

    private PacketUtils() {
    }

    public static byte[] extractDstMac(byte[] payload) {
        return Arrays.copyOfRange(payload, 0, 6);
    }

    public static byte[] extractSrcMac(byte[] payload) {
        return Arrays.copyOfRange(payload, 6, 12);
    }

    public static byte[] extractEtherType(byte[] payload) {
        return Arrays.copyOfRange(payload, 12, 14);
    }

    public static MacAddress rawMacToMac(byte[] rawMac) {
        MacAddress mac = null;
        if (rawMac != null && rawMac.length == 6) {
            StringBuilder sb = new StringBuilder();
            for (byte octet : rawMac) {
                sb.append(String.format(":%02X", octet));
            }
            mac = new MacAddress(sb.substring(1));
        }
        return mac;
    }

    public static NodeConnectorRef createNodeConnRef(InstanceIdentifier<Node> nodeInstId, NodeKey nodeKey, String port) {
        StringBuilder builder = new StringBuilder(nodeKey.getId().getValue()).append(':').append(port);
        NodeConnectorKey connKey = new NodeConnectorKey(new NodeConnectorId(builder.toString()));
        KeyedInstanceIdentifier portPath = nodeInstId.child(NodeConnector.class, (Key)connKey);
        return new NodeConnectorRef((InstanceIdentifier)portPath);
    }
}

