/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.group.rev700101.router.group;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.types.rev150122.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.group.rev700101.router.group.RoutersId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.router.group.rev700101.router.group.RoutersIdKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoutersIdBuilder
implements Builder<RoutersId> {
    private RoutersIdKey _key;
    private Uuid _routerId;
    Map<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>> augmentation = Collections.emptyMap();

    public RoutersIdBuilder() {
    }

    public RoutersIdBuilder(RoutersId base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RoutersIdKey(base.getRouterId());
            this._routerId = base.getRouterId();
        } else {
            this._key = base.getKey();
            this._routerId = this._key.getRouterId();
        }
        if (base instanceof RoutersIdImpl) {
            RoutersIdImpl impl = (RoutersIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>>(casted.augmentations());
        }
    }

    public RoutersIdKey getKey() {
        return this._key;
    }

    public Uuid getRouterId() {
        return this._routerId;
    }

    public <E extends Augmentation<RoutersId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RoutersIdBuilder setKey(RoutersIdKey value) {
        this._key = value;
        return this;
    }

    public RoutersIdBuilder setRouterId(Uuid value) {
        this._routerId = value;
        return this;
    }

    public RoutersIdBuilder addAugmentation(Class<? extends Augmentation<RoutersId>> augmentationType, Augmentation<RoutersId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RoutersIdBuilder removeAugmentation(Class<? extends Augmentation<RoutersId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoutersId build() {
        return new RoutersIdImpl(this);
    }

    private static final class RoutersIdImpl
    implements RoutersId {
        private final RoutersIdKey _key;
        private final Uuid _routerId;
        private Map<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RoutersId> getImplementedInterface() {
            return RoutersId.class;
        }

        private RoutersIdImpl(RoutersIdBuilder base) {
            if (base.getKey() == null) {
                this._key = new RoutersIdKey(base.getRouterId());
                this._routerId = base.getRouterId();
            } else {
                this._key = base.getKey();
                this._routerId = this._key.getRouterId();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>>(base.augmentation);
                }
            }
        }

        @Override
        public RoutersIdKey getKey() {
            return this._key;
        }

        @Override
        public Uuid getRouterId() {
            return this._routerId;
        }

        public <E extends Augmentation<RoutersId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._routerId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RoutersId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RoutersId other = (RoutersId)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._routerId, other.getRouterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RoutersIdImpl otherImpl = (RoutersIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RoutersId>>, Augmentation<RoutersId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RoutersId [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._routerId != null) {
                builder.append("_routerId=");
                builder.append(this._routerId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

