/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.nic.impl;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.nic.api.NicConsoleProvider;
import org.opendaylight.nic.compiler.api.Action;
import org.opendaylight.nic.compiler.api.IntentCompiler;
import org.opendaylight.nic.compiler.api.IntentCompilerFactory;
import org.opendaylight.nic.compiler.api.Policy;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.Intents;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.IntentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.Actions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.Subjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.actions.action.Allow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.actions.action.Block;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.subjects.subject.EndPointGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intents.Intent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intents.IntentKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.types.rev150122.Uuid;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicProvider
implements NicConsoleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NicProvider.class);
    protected DataBroker dataBroker;
    protected ServiceRegistration<NicConsoleProvider> nicConsoleRegistration;
    public static final InstanceIdentifier<Intents> INTENTS_IID = InstanceIdentifier.builder(Intents.class).build();

    public NicProvider(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
    }

    @Override
    public void close() throws Exception {
        this.nicConsoleRegistration.unregister();
        LOG.info("IntentengineImpl: registrations closed");
    }

    public void init() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.nicConsoleRegistration = context.registerService(NicConsoleProvider.class, (Object)this, null);
        this.initIntentsOperational();
        this.initIntentsConfiguration();
        LOG.info("Initialization done");
    }

    protected void initIntentsOperational() {
        Intents intents = new IntentsBuilder().build();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, INTENTS_IID, (DataObject)intents);
        Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                LOG.info("initIntentsOperational: transaction succeeded");
            }

            public void onFailure(Throwable throwable) {
                LOG.error("initIntentsOperational: transaction failed");
            }
        });
        LOG.info("initIntentsOperational: operational status populated: {}", (Object)intents);
    }

    protected void initIntentsConfiguration() {
        Intents intents = new IntentsBuilder().build();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, INTENTS_IID, (DataObject)intents);
        tx.submit();
        LOG.info("initIntentsConfiguration: default config populated: {}", (Object)intents);
    }

    @Override
    public boolean addIntent(Intent intent) {
        Intents intents;
        List<Intent> listOfIntents = this.listIntents(true);
        try {
            listOfIntents.add(intent);
            intents = new IntentsBuilder().setIntent(listOfIntents).build();
            WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
            tx.put(LogicalDatastoreType.CONFIGURATION, INTENTS_IID, (DataObject)intents);
            tx.submit();
        }
        catch (Exception e) {
            LOG.error("addIntent: failed: {}", (Throwable)e);
            return false;
        }
        LOG.info("initIntentsConfiguration: default config populated: {}", (Object)intents);
        return true;
    }

    @Override
    public boolean addIntents(Intents intents) {
        return false;
    }

    @Override
    public boolean removeIntent(Uuid id) {
        try {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(Intents.class).child(Intent.class, (Identifier)new IntentKey(id));
            WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
            tx.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)iid);
            tx.submit();
        }
        catch (Exception e) {
            LOG.info("RemoveIntent: failed: {}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeIntents(List<Uuid> intents) {
        return false;
    }

    @Override
    public List<Intent> listIntents(boolean isConfigurationDatastore) {
        List<Object> listOfIntents = null;
        try {
            ReadOnlyTransaction tx = this.dataBroker.newReadOnlyTransaction();
            listOfIntents = ((Intents)((Optional)tx.read(isConfigurationDatastore ? LogicalDatastoreType.CONFIGURATION : LogicalDatastoreType.OPERATIONAL, INTENTS_IID).checkedGet()).get()).getIntent();
        }
        catch (Exception e) {
            LOG.error("ListIntents: failed: {}", (Throwable)e);
        }
        if (listOfIntents == null) {
            listOfIntents = new ArrayList<Intent>();
        }
        LOG.info("ListIntentsConfiguration: list of intents retrieved sucessfully");
        return listOfIntents;
    }

    @Override
    public Intent getIntent(Uuid id) {
        Intent intent = null;
        try {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(Intents.class).child(Intent.class, (Identifier)new IntentKey(id));
            ReadOnlyTransaction tx = this.dataBroker.newReadOnlyTransaction();
            intent = (Intent)((Optional)tx.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)iid).checkedGet()).get();
            if (intent == null) {
                intent = (Intent)((Optional)tx.read(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)iid).checkedGet()).get();
            }
        }
        catch (Exception e) {
            LOG.error("getIntent: failed: {}", (Throwable)e);
            return null;
        }
        LOG.info("getIntent: Intent retrieved sucessfully");
        return intent;
    }

    @Override
    public String compile() {
        List<Intent> intents = this.listIntents(true);
        IntentCompiler compiler = IntentCompilerFactory.createIntentCompiler();
        LinkedList<Policy> policies = new LinkedList<Policy>();
        for (Intent intent : intents) {
            Action action;
            Set destinations;
            Set sources;
            EndPointGroup sourceContainer = (EndPointGroup)((Subjects)intent.getSubjects().get(0)).getSubject();
            EndPointGroup destinationContainer = (EndPointGroup)((Subjects)intent.getSubjects().get(1)).getSubject();
            org.opendaylight.yang.gen.v1.urn.opendaylight.intent.rev150122.intent.actions.Action actionContainer = ((Actions)intent.getActions().get(0)).getAction();
            try {
                sources = compiler.parseEndpointGroup(sourceContainer.getEndPointGroup().getName());
                destinations = compiler.parseEndpointGroup(destinationContainer.getEndPointGroup().getName());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return "ERROR";
            }
            if (actionContainer instanceof Allow) {
                action = Action.ALLOW;
            } else if (actionContainer instanceof Block) {
                action = Action.BLOCK;
            } else {
                return "ERROR";
            }
            policies.add(compiler.createPolicy(sources, destinations, action));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(">>> Original policies:\n");
        stringBuilder.append(this.formatPolicies(policies));
        stringBuilder.append('\n');
        stringBuilder.append(">>> Compiled policies:\n");
        Collection compiledPolicies = compiler.compile(policies);
        stringBuilder.append(this.formatPolicies(compiledPolicies));
        return stringBuilder.toString();
    }

    private String formatPolicies(Collection<Policy> policies) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Policy policy : policies) {
            stringBuilder.append(policy.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

