/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcDataProcessor;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingDataTreeListener<T extends DataObject>
implements AutoCloseable,
DataTreeChangeListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingDataTreeListener.class);
    protected INetvirtSfcOF13Provider provider;
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("NV-SfcDTL-%d").build();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1, threadFactory);
    private final INetvirtSfcDataProcessor<T> dataProcessor;
    private ListenerRegistration<DelegatingDataTreeListener<T>> listenerRegistration;

    public DelegatingDataTreeListener(INetvirtSfcOF13Provider provider, INetvirtSfcDataProcessor<T> dataProcessor, DataBroker db, DataTreeIdentifier<T> treeId) {
        this.provider = (INetvirtSfcOF13Provider)Preconditions.checkNotNull((Object)provider, (Object)"provider can not be null!");
        this.dataProcessor = (INetvirtSfcDataProcessor)Preconditions.checkNotNull(dataProcessor, (Object)"Data processor can not be null!");
        this.registerListener((DataBroker)Preconditions.checkNotNull((Object)db, (Object)"Data broker can not be null!"), (DataTreeIdentifier)Preconditions.checkNotNull(treeId, (Object)"Tree identifier can not be null!"));
    }

    private void registerListener(DataBroker db, DataTreeIdentifier<T> treeId) {
        try {
            LOG.info("Registering Data Change Listener for {}", (Object)this.getClass().getSimpleName());
            this.listenerRegistration = db.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)this);
        }
        catch (Exception e) {
            LOG.warn("{} DataChange listener registration fail!", (Object)this.getClass().getSimpleName(), (Object)e);
            throw new IllegalStateException("DataTreeListener startup fail! System needs restart.", e);
        }
    }

    private void processChanges(Collection<DataTreeModification<T>> changes) {
        LOG.info("onDataTreeChanged: Received Data Tree Changed ...", changes);
        block5: for (DataTreeModification<T> change : changes) {
            InstanceIdentifier key = change.getRootPath().getRootIdentifier();
            DataObjectModification mod = change.getRootNode();
            LOG.info("onDataTreeChanged: Received Data Tree Changed Update of Type={} for Key={}", (Object)mod.getModificationType(), (Object)key);
            switch (mod.getModificationType()) {
                case DELETE: {
                    this.dataProcessor.remove(key, mod.getDataBefore());
                    continue block5;
                }
                case SUBTREE_MODIFIED: {
                    this.dataProcessor.update(key, mod.getDataBefore(), mod.getDataAfter());
                    continue block5;
                }
                case WRITE: {
                    if (mod.getDataBefore() == null) {
                        this.dataProcessor.add(key, mod.getDataAfter());
                        continue block5;
                    }
                    this.dataProcessor.update(key, mod.getDataBefore(), mod.getDataAfter());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unhandled modification type " + mod.getModificationType());
        }
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<T>> changes) {
        Preconditions.checkNotNull(changes, (Object)"Changes may not be null!");
        this.executorService.submit(() -> this.processChanges(changes));
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
            this.listenerRegistration = null;
        }
    }
}

