/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentedException
extends Exception {
    public static final String RPC_ERROR = "rpc-error";
    public static final String ERROR_TYPE = "error-type";
    public static final String ERROR_TAG = "error-tag";
    public static final String ERROR_SEVERITY = "error-severity";
    public static final String ERROR_APP_TAG = "error-app-tag";
    public static final String ERROR_PATH = "error-path";
    public static final String ERROR_MESSAGE = "error-message";
    public static final String ERROR_INFO = "error-info";
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory BUILDER_FACTORY;
    private final ErrorType errorType;
    private final ErrorTag errorTag;
    private final ErrorSeverity errorSeverity;
    private final Map<String, String> errorInfo;

    public DocumentedException(String message) {
        this(message, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
    }

    public DocumentedException(String message, Exception cause) {
        this(message, cause, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
    }

    public DocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, errorType, errorTag, errorSeverity, Map.of());
    }

    public DocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public DocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, cause, errorType, errorTag, errorSeverity, Map.of());
    }

    public DocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message, cause);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public static DocumentedException wrap(Exception exception) throws DocumentedException {
        throw new DocumentedException(exception.getMessage(), exception, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, Map.of(ErrorTag.OPERATION_FAILED.elementBody(), "Exception thrown"));
    }

    public static DocumentedException fromXMLDocument(Document fromDoc) {
        ErrorType errorType = ErrorType.APPLICATION;
        ErrorTag errorTag = ErrorTag.OPERATION_FAILED;
        ErrorSeverity errorSeverity = ErrorSeverity.ERROR;
        Map<String, String> errorInfo = null;
        String errorMessage = "";
        StringBuilder allErrorMessages = new StringBuilder();
        Element rpcReply = fromDoc.getDocumentElement();
        int rpcErrorCount = 0;
        NodeList replyChildren = rpcReply.getChildNodes();
        int ilen = replyChildren.getLength();
        for (int i = 0; i < ilen; ++i) {
            Node replyChild = replyChildren.item(i);
            if (!RPC_ERROR.equals(replyChild.getLocalName())) continue;
            ++rpcErrorCount;
            NodeList rpcErrorChildren = replyChild.getChildNodes();
            int jlen = rpcErrorChildren.getLength();
            for (int j = 0; j < jlen; ++j) {
                Node rpcErrorChild = rpcErrorChildren.item(j);
                if (ERROR_TYPE.equals(rpcErrorChild.getLocalName())) {
                    ErrorType type = ErrorType.forElementBody((String)rpcErrorChild.getTextContent());
                    errorType = type != null ? type : ErrorType.APPLICATION;
                    continue;
                }
                if (ERROR_TAG.equals(rpcErrorChild.getLocalName())) {
                    errorTag = new ErrorTag(rpcErrorChild.getTextContent());
                    continue;
                }
                if (ERROR_SEVERITY.equals(rpcErrorChild.getLocalName())) {
                    ErrorSeverity sev = ErrorSeverity.forElementBody((String)rpcErrorChild.getTextContent());
                    errorSeverity = sev != null ? sev : ErrorSeverity.ERROR;
                    continue;
                }
                if (ERROR_MESSAGE.equals(rpcErrorChild.getLocalName())) {
                    errorMessage = rpcErrorChild.getTextContent();
                    allErrorMessages.append(errorMessage);
                    continue;
                }
                if (!ERROR_INFO.equals(rpcErrorChild.getLocalName())) continue;
                errorInfo = DocumentedException.parseErrorInfo(rpcErrorChild);
            }
        }
        if (rpcErrorCount > 1) {
            if (errorInfo == null) {
                errorInfo = new HashMap<String, String>();
            }
            errorInfo.put("Multiple Errors Found", allErrorMessages.toString());
        }
        return new DocumentedException(errorMessage, errorType, errorTag, errorSeverity, errorInfo);
    }

    private static Map<String, String> parseErrorInfo(Node node) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            infoMap.put(child.getNodeName(), child.getTextContent());
        }
        return infoMap;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public ErrorSeverity getErrorSeverity() {
        return this.errorSeverity;
    }

    public Map<String, String> getErrorInfo() {
        return this.errorInfo;
    }

    public final Document toXMLDocument() {
        Document doc;
        try {
            doc = BUILDER_FACTORY.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Error outputting to XML document", e);
        }
        Element rpcReply = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "rpc-reply");
        doc.appendChild(rpcReply);
        Element rpcError = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", RPC_ERROR);
        rpcReply.appendChild(rpcError);
        rpcError.appendChild(DocumentedException.createTextNode(doc, ERROR_TYPE, this.getErrorType().elementBody()));
        rpcError.appendChild(DocumentedException.createTextNode(doc, ERROR_TAG, this.getErrorTag().elementBody()));
        rpcError.appendChild(DocumentedException.createTextNode(doc, ERROR_SEVERITY, this.getErrorSeverity().elementBody()));
        rpcError.appendChild(DocumentedException.createTextNode(doc, ERROR_MESSAGE, this.getLocalizedMessage()));
        Map<String, String> errorInfoMap = this.getErrorInfo();
        if (errorInfoMap != null && !errorInfoMap.isEmpty()) {
            Element errorInfoNode = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", ERROR_INFO);
            errorInfoNode.setPrefix(rpcReply.getPrefix());
            rpcError.appendChild(errorInfoNode);
            for (Map.Entry<String, String> entry : errorInfoMap.entrySet()) {
                errorInfoNode.appendChild(DocumentedException.createTextNode(doc, entry.getKey(), entry.getValue()));
            }
        }
        return doc;
    }

    private static Node createTextNode(Document doc, String tag, String textContent) {
        Element node = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", tag);
        node.setTextContent(textContent);
        return node;
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add(ERROR_TYPE, (Object)this.errorType).add(ERROR_TAG, (Object)this.errorTag).add(ERROR_SEVERITY, (Object)this.errorSeverity).add(ERROR_INFO, this.errorInfo).add("message", (Object)this.getMessage());
    }

    static {
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        try {
            bf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            bf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            bf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            bf.setXIncludeAware(false);
            bf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        bf.setNamespaceAware(true);
        bf.setCoalescing(true);
        bf.setIgnoringElementContentWhitespace(true);
        bf.setIgnoringComments(true);
        BUILDER_FACTORY = bf;
    }
}

