/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.ready.karaf.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.opendaylight.infrautils.ready.order.FunctionalityReady;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtil.class);
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;

    private ProxyUtil() {
    }

    private static void initializeMethods() {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("getMethod() failed", (Throwable)e);
            NoSuchMethodError noSuchMethodError = new NoSuchMethodError(e.getMessage());
            noSuchMethodError.initCause(e);
            throw noSuchMethodError;
        }
    }

    static <T extends FunctionalityReady> T newInstance(Class<T> markerInterface) {
        return (T)((FunctionalityReady)Proxy.newProxyInstance(markerInterface.getClassLoader(), new Class[]{markerInterface}, (InvocationHandler)new Delegator()));
    }

    static {
        ProxyUtil.initializeMethods();
    }

    private static final class Delegator
    implements InvocationHandler {
        private Delegator() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) {
                if (method.equals(hashCodeMethod)) {
                    return Delegator.proxyHashCode(proxy);
                }
                if (method.equals(equalsMethod)) {
                    return Delegator.proxyEquals(proxy, args[0]);
                }
                if (method.equals(toStringMethod)) {
                    return Delegator.proxyToString(proxy);
                }
                throw new InternalError("unexpected Object method dispatched: " + method);
            }
            return Delegator.invokeNotDelegated(proxy, method, args);
        }

        private static Object invokeNotDelegated(Object proxy, Method method, Object[] args) {
            throw new UnsupportedOperationException("FunctionalityReady interfaces should not have any methods: " + method);
        }

        private static int proxyHashCode(Object proxy) {
            return System.identityHashCode(proxy);
        }

        private static Boolean proxyEquals(Object proxy, Object other) {
            return proxy == other ? Boolean.TRUE : Boolean.FALSE;
        }

        private static String proxyToString(Object proxy) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
        }
    }
}

