/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.services.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.ServiceTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.services.info.BoundServices;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.service.bindings.services.info.BoundServicesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BoundServicesBuilder
implements Builder<BoundServices> {
    private BoundServicesKey _key;
    private String _serviceName;
    private Short _servicePriority;
    private Class<? extends ServiceTypeBase> _serviceType;
    Map<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>> augmentation = Collections.emptyMap();

    public BoundServicesBuilder() {
    }

    public BoundServicesBuilder(BoundServices base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BoundServicesKey(base.getServicePriority());
            this._servicePriority = base.getServicePriority();
        } else {
            this._key = base.getKey();
            this._servicePriority = this._key.getServicePriority();
        }
        this._serviceName = base.getServiceName();
        this._serviceType = base.getServiceType();
        if (base instanceof BoundServicesImpl) {
            BoundServicesImpl impl = (BoundServicesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>>(casted.augmentations());
        }
    }

    public BoundServicesKey getKey() {
        return this._key;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public Short getServicePriority() {
        return this._servicePriority;
    }

    public Class<? extends ServiceTypeBase> getServiceType() {
        return this._serviceType;
    }

    public <E extends Augmentation<BoundServices>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BoundServicesBuilder setKey(BoundServicesKey value) {
        this._key = value;
        return this;
    }

    public BoundServicesBuilder setServiceName(String value) {
        this._serviceName = value;
        return this;
    }

    private static void checkServicePriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public BoundServicesBuilder setServicePriority(Short value) {
        if (value != null) {
            BoundServicesBuilder.checkServicePriorityRange(value);
        }
        this._servicePriority = value;
        return this;
    }

    public BoundServicesBuilder setServiceType(Class<? extends ServiceTypeBase> value) {
        this._serviceType = value;
        return this;
    }

    public BoundServicesBuilder addAugmentation(Class<? extends Augmentation<BoundServices>> augmentationType, Augmentation<BoundServices> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BoundServicesBuilder removeAugmentation(Class<? extends Augmentation<BoundServices>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BoundServices build() {
        return new BoundServicesImpl(this);
    }

    private static final class BoundServicesImpl
    implements BoundServices {
        private final BoundServicesKey _key;
        private final String _serviceName;
        private final Short _servicePriority;
        private final Class<? extends ServiceTypeBase> _serviceType;
        private Map<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BoundServices> getImplementedInterface() {
            return BoundServices.class;
        }

        private BoundServicesImpl(BoundServicesBuilder base) {
            if (base.getKey() == null) {
                this._key = new BoundServicesKey(base.getServicePriority());
                this._servicePriority = base.getServicePriority();
            } else {
                this._key = base.getKey();
                this._servicePriority = this._key.getServicePriority();
            }
            this._serviceName = base.getServiceName();
            this._serviceType = base.getServiceType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>>(base.augmentation);
                }
            }
        }

        @Override
        public BoundServicesKey getKey() {
            return this._key;
        }

        @Override
        public String getServiceName() {
            return this._serviceName;
        }

        @Override
        public Short getServicePriority() {
            return this._servicePriority;
        }

        @Override
        public Class<? extends ServiceTypeBase> getServiceType() {
            return this._serviceType;
        }

        public <E extends Augmentation<BoundServices>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceName);
            result = 31 * result + Objects.hashCode(this._servicePriority);
            result = 31 * result + Objects.hashCode(this._serviceType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BoundServices.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BoundServices other = (BoundServices)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceName, other.getServiceName())) {
                return false;
            }
            if (!Objects.equals(this._servicePriority, other.getServicePriority())) {
                return false;
            }
            if (!Objects.equals(this._serviceType, other.getServiceType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BoundServicesImpl otherImpl = (BoundServicesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BoundServices>>, Augmentation<BoundServices>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BoundServices [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceName != null) {
                builder.append("_serviceName=");
                builder.append(this._serviceName);
                builder.append(", ");
            }
            if (this._servicePriority != null) {
                builder.append("_servicePriority=");
                builder.append(this._servicePriority);
                builder.append(", ");
            }
            if (this._serviceType != null) {
                builder.append("_serviceType=");
                builder.append(this._serviceType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

