/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.bound.services.state.list;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.ServiceModeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.bound.services.state.list.BoundServicesState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.servicebinding.rev160406.bound.services.state.list.BoundServicesStateKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BoundServicesStateBuilder
implements Builder<BoundServicesState> {
    private BigInteger _dpid;
    private Integer _ifIndex;
    private String _interfaceName;
    private Class<? extends InterfaceType> _interfaceType;
    private BoundServicesStateKey _key;
    private Long _portNo;
    private Class<? extends ServiceModeBase> _serviceMode;
    Map<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public BoundServicesStateBuilder() {
    }

    public BoundServicesStateBuilder(BoundServicesState base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BoundServicesStateKey(base.getInterfaceName(), base.getServiceMode());
            this._interfaceName = base.getInterfaceName();
            this._serviceMode = base.getServiceMode();
        } else {
            this._key = base.getKey();
            this._interfaceName = this._key.getInterfaceName();
            this._serviceMode = this._key.getServiceMode();
        }
        this._dpid = base.getDpid();
        this._ifIndex = base.getIfIndex();
        this._interfaceType = base.getInterfaceType();
        this._portNo = base.getPortNo();
        if (base instanceof BoundServicesStateImpl) {
            BoundServicesStateImpl impl = (BoundServicesStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>>(casted.augmentations());
        }
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public Integer getIfIndex() {
        return this._ifIndex;
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public Class<? extends InterfaceType> getInterfaceType() {
        return this._interfaceType;
    }

    public BoundServicesStateKey getKey() {
        return this._key;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public Class<? extends ServiceModeBase> getServiceMode() {
        return this._serviceMode;
    }

    public <E extends Augmentation<BoundServicesState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public BoundServicesStateBuilder setDpid(BigInteger value) {
        if (value != null) {
            BoundServicesStateBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public BoundServicesStateBuilder setIfIndex(Integer value) {
        this._ifIndex = value;
        return this;
    }

    public BoundServicesStateBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public BoundServicesStateBuilder setInterfaceType(Class<? extends InterfaceType> value) {
        this._interfaceType = value;
        return this;
    }

    public BoundServicesStateBuilder setKey(BoundServicesStateKey value) {
        this._key = value;
        return this;
    }

    private static void checkPortNoRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public BoundServicesStateBuilder setPortNo(Long value) {
        if (value != null) {
            BoundServicesStateBuilder.checkPortNoRange(value);
        }
        this._portNo = value;
        return this;
    }

    public BoundServicesStateBuilder setServiceMode(Class<? extends ServiceModeBase> value) {
        this._serviceMode = value;
        return this;
    }

    public BoundServicesStateBuilder addAugmentation(Class<? extends Augmentation<BoundServicesState>> augmentationType, Augmentation<BoundServicesState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BoundServicesStateBuilder removeAugmentation(Class<? extends Augmentation<BoundServicesState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BoundServicesState build() {
        return new BoundServicesStateImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class BoundServicesStateImpl
    implements BoundServicesState {
        private final BigInteger _dpid;
        private final Integer _ifIndex;
        private final String _interfaceName;
        private final Class<? extends InterfaceType> _interfaceType;
        private final BoundServicesStateKey _key;
        private final Long _portNo;
        private final Class<? extends ServiceModeBase> _serviceMode;
        private Map<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BoundServicesState> getImplementedInterface() {
            return BoundServicesState.class;
        }

        private BoundServicesStateImpl(BoundServicesStateBuilder base) {
            if (base.getKey() == null) {
                this._key = new BoundServicesStateKey(base.getInterfaceName(), base.getServiceMode());
                this._interfaceName = base.getInterfaceName();
                this._serviceMode = base.getServiceMode();
            } else {
                this._key = base.getKey();
                this._interfaceName = this._key.getInterfaceName();
                this._serviceMode = this._key.getServiceMode();
            }
            this._dpid = base.getDpid();
            this._ifIndex = base.getIfIndex();
            this._interfaceType = base.getInterfaceType();
            this._portNo = base.getPortNo();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        @Override
        public Integer getIfIndex() {
            return this._ifIndex;
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public Class<? extends InterfaceType> getInterfaceType() {
            return this._interfaceType;
        }

        @Override
        public BoundServicesStateKey getKey() {
            return this._key;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public Class<? extends ServiceModeBase> getServiceMode() {
            return this._serviceMode;
        }

        public <E extends Augmentation<BoundServicesState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dpid);
            result = 31 * result + Objects.hashCode(this._ifIndex);
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._interfaceType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._portNo);
            result = 31 * result + Objects.hashCode(this._serviceMode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BoundServicesState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BoundServicesState other = (BoundServicesState)obj;
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (!Objects.equals(this._ifIndex, other.getIfIndex())) {
                return false;
            }
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._interfaceType, other.getInterfaceType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._portNo, other.getPortNo())) {
                return false;
            }
            if (!Objects.equals(this._serviceMode, other.getServiceMode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BoundServicesStateImpl otherImpl = (BoundServicesStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BoundServicesState>>, Augmentation<BoundServicesState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BoundServicesState [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
                builder.append(", ");
            }
            if (this._ifIndex != null) {
                builder.append("_ifIndex=");
                builder.append(this._ifIndex);
                builder.append(", ");
            }
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._interfaceType != null) {
                builder.append("_interfaceType=");
                builder.append(this._interfaceType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._portNo != null) {
                builder.append("_portNo=");
                builder.append(this._portNo);
                builder.append(", ");
            }
            if (this._serviceMode != null) {
                builder.append("_serviceMode=");
                builder.append(this._serviceMode);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

