/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406.GetEgressInstructionsForInterfaceInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetEgressInstructionsForInterfaceInputBuilder
implements Builder<GetEgressInstructionsForInterfaceInput> {
    private String _intfName;
    private Long _tunnelKey;
    Map<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>> augmentation = Collections.emptyMap();

    public GetEgressInstructionsForInterfaceInputBuilder() {
    }

    public GetEgressInstructionsForInterfaceInputBuilder(GetEgressInstructionsForInterfaceInput base) {
        AugmentationHolder casted;
        this._intfName = base.getIntfName();
        this._tunnelKey = base.getTunnelKey();
        if (base instanceof GetEgressInstructionsForInterfaceInputImpl) {
            GetEgressInstructionsForInterfaceInputImpl impl = (GetEgressInstructionsForInterfaceInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>>(casted.augmentations());
        }
    }

    public String getIntfName() {
        return this._intfName;
    }

    public Long getTunnelKey() {
        return this._tunnelKey;
    }

    public <E extends Augmentation<GetEgressInstructionsForInterfaceInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetEgressInstructionsForInterfaceInputBuilder setIntfName(String value) {
        this._intfName = value;
        return this;
    }

    private static void checkTunnelKeyRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public GetEgressInstructionsForInterfaceInputBuilder setTunnelKey(Long value) {
        if (value != null) {
            GetEgressInstructionsForInterfaceInputBuilder.checkTunnelKeyRange(value);
        }
        this._tunnelKey = value;
        return this;
    }

    public GetEgressInstructionsForInterfaceInputBuilder addAugmentation(Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>> augmentationType, Augmentation<GetEgressInstructionsForInterfaceInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GetEgressInstructionsForInterfaceInputBuilder removeAugmentation(Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetEgressInstructionsForInterfaceInput build() {
        return new GetEgressInstructionsForInterfaceInputImpl(this);
    }

    private static final class GetEgressInstructionsForInterfaceInputImpl
    implements GetEgressInstructionsForInterfaceInput {
        private final String _intfName;
        private final Long _tunnelKey;
        private Map<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetEgressInstructionsForInterfaceInput> getImplementedInterface() {
            return GetEgressInstructionsForInterfaceInput.class;
        }

        private GetEgressInstructionsForInterfaceInputImpl(GetEgressInstructionsForInterfaceInputBuilder base) {
            this._intfName = base.getIntfName();
            this._tunnelKey = base.getTunnelKey();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>>(base.augmentation);
                }
            }
        }

        @Override
        public String getIntfName() {
            return this._intfName;
        }

        @Override
        public Long getTunnelKey() {
            return this._tunnelKey;
        }

        public <E extends Augmentation<GetEgressInstructionsForInterfaceInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._intfName);
            result = 31 * result + Objects.hashCode(this._tunnelKey);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetEgressInstructionsForInterfaceInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetEgressInstructionsForInterfaceInput other = (GetEgressInstructionsForInterfaceInput)obj;
            if (!Objects.equals(this._intfName, other.getIntfName())) {
                return false;
            }
            if (!Objects.equals(this._tunnelKey, other.getTunnelKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetEgressInstructionsForInterfaceInputImpl otherImpl = (GetEgressInstructionsForInterfaceInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetEgressInstructionsForInterfaceInput>>, Augmentation<GetEgressInstructionsForInterfaceInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetEgressInstructionsForInterfaceInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._intfName != null) {
                builder.append("_intfName=");
                builder.append(this._intfName);
                builder.append(", ");
            }
            if (this._tunnelKey != null) {
                builder.append("_tunnelKey=");
                builder.append(this._tunnelKey);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

