/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rpcs.rev160406.GetDpidFromInterfaceOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetDpidFromInterfaceOutputBuilder
implements Builder<GetDpidFromInterfaceOutput> {
    private BigInteger _dpid;
    Map<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public GetDpidFromInterfaceOutputBuilder() {
    }

    public GetDpidFromInterfaceOutputBuilder(GetDpidFromInterfaceOutput base) {
        AugmentationHolder casted;
        this._dpid = base.getDpid();
        if (base instanceof GetDpidFromInterfaceOutputImpl) {
            GetDpidFromInterfaceOutputImpl impl = (GetDpidFromInterfaceOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>>(casted.augmentations());
        }
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public <E extends Augmentation<GetDpidFromInterfaceOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public GetDpidFromInterfaceOutputBuilder setDpid(BigInteger value) {
        if (value != null) {
            GetDpidFromInterfaceOutputBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public GetDpidFromInterfaceOutputBuilder addAugmentation(Class<? extends Augmentation<GetDpidFromInterfaceOutput>> augmentationType, Augmentation<GetDpidFromInterfaceOutput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GetDpidFromInterfaceOutputBuilder removeAugmentation(Class<? extends Augmentation<GetDpidFromInterfaceOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetDpidFromInterfaceOutput build() {
        return new GetDpidFromInterfaceOutputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class GetDpidFromInterfaceOutputImpl
    implements GetDpidFromInterfaceOutput {
        private final BigInteger _dpid;
        private Map<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetDpidFromInterfaceOutput> getImplementedInterface() {
            return GetDpidFromInterfaceOutput.class;
        }

        private GetDpidFromInterfaceOutputImpl(GetDpidFromInterfaceOutputBuilder base) {
            this._dpid = base.getDpid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        public <E extends Augmentation<GetDpidFromInterfaceOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dpid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetDpidFromInterfaceOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetDpidFromInterfaceOutput other = (GetDpidFromInterfaceOutput)obj;
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetDpidFromInterfaceOutputImpl otherImpl = (GetDpidFromInterfaceOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetDpidFromInterfaceOutput>>, Augmentation<GetDpidFromInterfaceOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetDpidFromInterfaceOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

