/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.interfaces._interface.NodeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.interfaces._interface.NodeIdentifierKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeIdentifierBuilder
implements Builder<NodeIdentifier> {
    private NodeIdentifierKey _key;
    private String _nodeId;
    private String _topologyId;
    Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = Collections.emptyMap();

    public NodeIdentifierBuilder() {
    }

    public NodeIdentifierBuilder(NodeIdentifier base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NodeIdentifierKey(base.getTopologyId());
            this._topologyId = base.getTopologyId();
        } else {
            this._key = base.getKey();
            this._topologyId = this._key.getTopologyId();
        }
        this._nodeId = base.getNodeId();
        if (base instanceof NodeIdentifierImpl) {
            NodeIdentifierImpl impl = (NodeIdentifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>(casted.augmentations());
        }
    }

    public NodeIdentifierKey getKey() {
        return this._key;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getTopologyId() {
        return this._topologyId;
    }

    public <E extends Augmentation<NodeIdentifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeIdentifierBuilder setKey(NodeIdentifierKey value) {
        this._key = value;
        return this;
    }

    public NodeIdentifierBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public NodeIdentifierBuilder setTopologyId(String value) {
        this._topologyId = value;
        return this;
    }

    public NodeIdentifierBuilder addAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType, Augmentation<NodeIdentifier> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeIdentifierBuilder removeAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeIdentifier build() {
        return new NodeIdentifierImpl(this);
    }

    private static final class NodeIdentifierImpl
    implements NodeIdentifier {
        private final NodeIdentifierKey _key;
        private final String _nodeId;
        private final String _topologyId;
        private Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NodeIdentifier> getImplementedInterface() {
            return NodeIdentifier.class;
        }

        private NodeIdentifierImpl(NodeIdentifierBuilder base) {
            if (base.getKey() == null) {
                this._key = new NodeIdentifierKey(base.getTopologyId());
                this._topologyId = base.getTopologyId();
            } else {
                this._key = base.getKey();
                this._topologyId = this._key.getTopologyId();
            }
            this._nodeId = base.getNodeId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeIdentifierKey getKey() {
            return this._key;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public String getTopologyId() {
            return this._topologyId;
        }

        public <E extends Augmentation<NodeIdentifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._topologyId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeIdentifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeIdentifier other = (NodeIdentifier)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._topologyId, other.getTopologyId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeIdentifierImpl otherImpl = (NodeIdentifierImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NodeIdentifier [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
                builder.append(", ");
            }
            if (this._topologyId != null) {
                builder.append("_topologyId=");
                builder.append(this._topologyId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

