/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406;

import java.util.List;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.IfTunnel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.MonitorParams;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.TunnelMonitoringTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.TunnelOptionalParams;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.TunnelTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.monitor.params.MonitorConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.tunnel.optional.params.TunnelOptions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IfTunnelBuilder
implements Builder<IfTunnel> {
    private List<MonitorConfig> _monitorConfig;
    private Long _monitorInterval;
    private Class<? extends TunnelMonitoringTypeBase> _monitorProtocol;
    private IpAddress _tunnelDestination;
    private IpAddress _tunnelGateway;
    private Class<? extends TunnelTypeBase> _tunnelInterfaceType;
    private List<TunnelOptions> _tunnelOptions;
    private IpAddress _tunnelSource;
    private Integer _weight;
    private Boolean _internal;
    private Boolean _monitorEnabled;
    private Boolean _tunnelRemoteIpFlow;
    private Boolean _tunnelSourceIpFlow;

    public IfTunnelBuilder() {
    }

    public IfTunnelBuilder(TunnelOptionalParams arg) {
        this._tunnelSourceIpFlow = arg.isTunnelSourceIpFlow();
        this._tunnelRemoteIpFlow = arg.isTunnelRemoteIpFlow();
        this._weight = arg.getWeight();
        this._tunnelOptions = arg.getTunnelOptions();
    }

    public IfTunnelBuilder(MonitorParams arg) {
        this._monitorEnabled = arg.isMonitorEnabled();
        this._monitorInterval = arg.getMonitorInterval();
        this._monitorProtocol = arg.getMonitorProtocol();
        this._monitorConfig = arg.getMonitorConfig();
    }

    public IfTunnelBuilder(IfTunnel base) {
        this._monitorConfig = base.getMonitorConfig();
        this._monitorInterval = base.getMonitorInterval();
        this._monitorProtocol = base.getMonitorProtocol();
        this._tunnelDestination = base.getTunnelDestination();
        this._tunnelGateway = base.getTunnelGateway();
        this._tunnelInterfaceType = base.getTunnelInterfaceType();
        this._tunnelOptions = base.getTunnelOptions();
        this._tunnelSource = base.getTunnelSource();
        this._weight = base.getWeight();
        this._internal = base.isInternal();
        this._monitorEnabled = base.isMonitorEnabled();
        this._tunnelRemoteIpFlow = base.isTunnelRemoteIpFlow();
        this._tunnelSourceIpFlow = base.isTunnelSourceIpFlow();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MonitorParams) {
            this._monitorEnabled = ((MonitorParams)arg).isMonitorEnabled();
            this._monitorInterval = ((MonitorParams)arg).getMonitorInterval();
            this._monitorProtocol = ((MonitorParams)arg).getMonitorProtocol();
            this._monitorConfig = ((MonitorParams)arg).getMonitorConfig();
            isValidArg = true;
        }
        if (arg instanceof TunnelOptionalParams) {
            this._tunnelSourceIpFlow = ((TunnelOptionalParams)arg).isTunnelSourceIpFlow();
            this._tunnelRemoteIpFlow = ((TunnelOptionalParams)arg).isTunnelRemoteIpFlow();
            this._weight = ((TunnelOptionalParams)arg).getWeight();
            this._tunnelOptions = ((TunnelOptionalParams)arg).getTunnelOptions();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.MonitorParams, org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.TunnelOptionalParams] \nbut was: " + arg);
        }
    }

    public List<MonitorConfig> getMonitorConfig() {
        return this._monitorConfig;
    }

    public Long getMonitorInterval() {
        return this._monitorInterval;
    }

    public Class<? extends TunnelMonitoringTypeBase> getMonitorProtocol() {
        return this._monitorProtocol;
    }

    public IpAddress getTunnelDestination() {
        return this._tunnelDestination;
    }

    public IpAddress getTunnelGateway() {
        return this._tunnelGateway;
    }

    public Class<? extends TunnelTypeBase> getTunnelInterfaceType() {
        return this._tunnelInterfaceType;
    }

    public List<TunnelOptions> getTunnelOptions() {
        return this._tunnelOptions;
    }

    public IpAddress getTunnelSource() {
        return this._tunnelSource;
    }

    public Integer getWeight() {
        return this._weight;
    }

    public Boolean isInternal() {
        return this._internal;
    }

    public Boolean isMonitorEnabled() {
        return this._monitorEnabled;
    }

    public Boolean isTunnelRemoteIpFlow() {
        return this._tunnelRemoteIpFlow;
    }

    public Boolean isTunnelSourceIpFlow() {
        return this._tunnelSourceIpFlow;
    }

    public IfTunnelBuilder setMonitorConfig(List<MonitorConfig> value) {
        this._monitorConfig = value;
        return this;
    }

    private static void checkMonitorIntervalRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public IfTunnelBuilder setMonitorInterval(Long value) {
        if (value != null) {
            IfTunnelBuilder.checkMonitorIntervalRange(value);
        }
        this._monitorInterval = value;
        return this;
    }

    public IfTunnelBuilder setMonitorProtocol(Class<? extends TunnelMonitoringTypeBase> value) {
        this._monitorProtocol = value;
        return this;
    }

    public IfTunnelBuilder setTunnelDestination(IpAddress value) {
        this._tunnelDestination = value;
        return this;
    }

    public IfTunnelBuilder setTunnelGateway(IpAddress value) {
        this._tunnelGateway = value;
        return this;
    }

    public IfTunnelBuilder setTunnelInterfaceType(Class<? extends TunnelTypeBase> value) {
        this._tunnelInterfaceType = value;
        return this;
    }

    public IfTunnelBuilder setTunnelOptions(List<TunnelOptions> value) {
        this._tunnelOptions = value;
        return this;
    }

    public IfTunnelBuilder setTunnelSource(IpAddress value) {
        this._tunnelSource = value;
        return this;
    }

    private static void checkWeightRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public IfTunnelBuilder setWeight(Integer value) {
        if (value != null) {
            IfTunnelBuilder.checkWeightRange(value);
        }
        this._weight = value;
        return this;
    }

    public IfTunnelBuilder setInternal(Boolean value) {
        this._internal = value;
        return this;
    }

    public IfTunnelBuilder setMonitorEnabled(Boolean value) {
        this._monitorEnabled = value;
        return this;
    }

    public IfTunnelBuilder setTunnelRemoteIpFlow(Boolean value) {
        this._tunnelRemoteIpFlow = value;
        return this;
    }

    public IfTunnelBuilder setTunnelSourceIpFlow(Boolean value) {
        this._tunnelSourceIpFlow = value;
        return this;
    }

    public IfTunnel build() {
        return new IfTunnelImpl(this);
    }

    private static final class IfTunnelImpl
    implements IfTunnel {
        private final List<MonitorConfig> _monitorConfig;
        private final Long _monitorInterval;
        private final Class<? extends TunnelMonitoringTypeBase> _monitorProtocol;
        private final IpAddress _tunnelDestination;
        private final IpAddress _tunnelGateway;
        private final Class<? extends TunnelTypeBase> _tunnelInterfaceType;
        private final List<TunnelOptions> _tunnelOptions;
        private final IpAddress _tunnelSource;
        private final Integer _weight;
        private final Boolean _internal;
        private final Boolean _monitorEnabled;
        private final Boolean _tunnelRemoteIpFlow;
        private final Boolean _tunnelSourceIpFlow;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IfTunnel> getImplementedInterface() {
            return IfTunnel.class;
        }

        private IfTunnelImpl(IfTunnelBuilder base) {
            this._monitorConfig = base.getMonitorConfig();
            this._monitorInterval = base.getMonitorInterval();
            this._monitorProtocol = base.getMonitorProtocol();
            this._tunnelDestination = base.getTunnelDestination();
            this._tunnelGateway = base.getTunnelGateway();
            this._tunnelInterfaceType = base.getTunnelInterfaceType();
            this._tunnelOptions = base.getTunnelOptions();
            this._tunnelSource = base.getTunnelSource();
            this._weight = base.getWeight();
            this._internal = base.isInternal();
            this._monitorEnabled = base.isMonitorEnabled();
            this._tunnelRemoteIpFlow = base.isTunnelRemoteIpFlow();
            this._tunnelSourceIpFlow = base.isTunnelSourceIpFlow();
        }

        @Override
        public List<MonitorConfig> getMonitorConfig() {
            return this._monitorConfig;
        }

        @Override
        public Long getMonitorInterval() {
            return this._monitorInterval;
        }

        @Override
        public Class<? extends TunnelMonitoringTypeBase> getMonitorProtocol() {
            return this._monitorProtocol;
        }

        @Override
        public IpAddress getTunnelDestination() {
            return this._tunnelDestination;
        }

        @Override
        public IpAddress getTunnelGateway() {
            return this._tunnelGateway;
        }

        @Override
        public Class<? extends TunnelTypeBase> getTunnelInterfaceType() {
            return this._tunnelInterfaceType;
        }

        @Override
        public List<TunnelOptions> getTunnelOptions() {
            return this._tunnelOptions;
        }

        @Override
        public IpAddress getTunnelSource() {
            return this._tunnelSource;
        }

        @Override
        public Integer getWeight() {
            return this._weight;
        }

        @Override
        public Boolean isInternal() {
            return this._internal;
        }

        @Override
        public Boolean isMonitorEnabled() {
            return this._monitorEnabled;
        }

        @Override
        public Boolean isTunnelRemoteIpFlow() {
            return this._tunnelRemoteIpFlow;
        }

        @Override
        public Boolean isTunnelSourceIpFlow() {
            return this._tunnelSourceIpFlow;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitorConfig);
            result = 31 * result + Objects.hashCode(this._monitorInterval);
            result = 31 * result + Objects.hashCode(this._monitorProtocol);
            result = 31 * result + Objects.hashCode(this._tunnelDestination);
            result = 31 * result + Objects.hashCode(this._tunnelGateway);
            result = 31 * result + Objects.hashCode(this._tunnelInterfaceType);
            result = 31 * result + Objects.hashCode(this._tunnelOptions);
            result = 31 * result + Objects.hashCode(this._tunnelSource);
            result = 31 * result + Objects.hashCode(this._weight);
            result = 31 * result + Objects.hashCode(this._internal);
            result = 31 * result + Objects.hashCode(this._monitorEnabled);
            result = 31 * result + Objects.hashCode(this._tunnelRemoteIpFlow);
            this.hash = result = 31 * result + Objects.hashCode(this._tunnelSourceIpFlow);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IfTunnel.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IfTunnel other = (IfTunnel)obj;
            if (!Objects.equals(this._monitorConfig, other.getMonitorConfig())) {
                return false;
            }
            if (!Objects.equals(this._monitorInterval, other.getMonitorInterval())) {
                return false;
            }
            if (!Objects.equals(this._monitorProtocol, other.getMonitorProtocol())) {
                return false;
            }
            if (!Objects.equals(this._tunnelDestination, other.getTunnelDestination())) {
                return false;
            }
            if (!Objects.equals(this._tunnelGateway, other.getTunnelGateway())) {
                return false;
            }
            if (!Objects.equals(this._tunnelInterfaceType, other.getTunnelInterfaceType())) {
                return false;
            }
            if (!Objects.equals(this._tunnelOptions, other.getTunnelOptions())) {
                return false;
            }
            if (!Objects.equals(this._tunnelSource, other.getTunnelSource())) {
                return false;
            }
            if (!Objects.equals(this._weight, other.getWeight())) {
                return false;
            }
            if (!Objects.equals(this._internal, other.isInternal())) {
                return false;
            }
            if (!Objects.equals(this._monitorEnabled, other.isMonitorEnabled())) {
                return false;
            }
            if (!Objects.equals(this._tunnelRemoteIpFlow, other.isTunnelRemoteIpFlow())) {
                return false;
            }
            return Objects.equals(this._tunnelSourceIpFlow, other.isTunnelSourceIpFlow());
        }

        public String toString() {
            String name = "IfTunnel [";
            StringBuilder builder = new StringBuilder(name);
            if (this._monitorConfig != null) {
                builder.append("_monitorConfig=");
                builder.append(this._monitorConfig);
                builder.append(", ");
            }
            if (this._monitorInterval != null) {
                builder.append("_monitorInterval=");
                builder.append(this._monitorInterval);
                builder.append(", ");
            }
            if (this._monitorProtocol != null) {
                builder.append("_monitorProtocol=");
                builder.append(this._monitorProtocol);
                builder.append(", ");
            }
            if (this._tunnelDestination != null) {
                builder.append("_tunnelDestination=");
                builder.append(this._tunnelDestination);
                builder.append(", ");
            }
            if (this._tunnelGateway != null) {
                builder.append("_tunnelGateway=");
                builder.append(this._tunnelGateway);
                builder.append(", ");
            }
            if (this._tunnelInterfaceType != null) {
                builder.append("_tunnelInterfaceType=");
                builder.append(this._tunnelInterfaceType);
                builder.append(", ");
            }
            if (this._tunnelOptions != null) {
                builder.append("_tunnelOptions=");
                builder.append(this._tunnelOptions);
                builder.append(", ");
            }
            if (this._tunnelSource != null) {
                builder.append("_tunnelSource=");
                builder.append(this._tunnelSource);
                builder.append(", ");
            }
            if (this._weight != null) {
                builder.append("_weight=");
                builder.append(this._weight);
                builder.append(", ");
            }
            if (this._internal != null) {
                builder.append("_internal=");
                builder.append(this._internal);
                builder.append(", ");
            }
            if (this._monitorEnabled != null) {
                builder.append("_monitorEnabled=");
                builder.append(this._monitorEnabled);
                builder.append(", ");
            }
            if (this._tunnelRemoteIpFlow != null) {
                builder.append("_tunnelRemoteIpFlow=");
                builder.append(this._tunnelRemoteIpFlow);
                builder.append(", ");
            }
            if (this._tunnelSourceIpFlow != null) {
                builder.append("_tunnelSourceIpFlow=");
                builder.append(this._tunnelSourceIpFlow);
            }
            return builder.append(']').toString();
        }
    }
}

