/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.IfStackedVlan;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IfStackedVlanBuilder
implements Builder<IfStackedVlan> {
    private Integer _stackedVlanId;

    public IfStackedVlanBuilder() {
    }

    public IfStackedVlanBuilder(IfStackedVlan base) {
        this._stackedVlanId = base.getStackedVlanId();
    }

    public Integer getStackedVlanId() {
        return this._stackedVlanId;
    }

    private static void checkStackedVlanIdRange(int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..4094]].", value));
    }

    public IfStackedVlanBuilder setStackedVlanId(Integer value) {
        if (value != null) {
            IfStackedVlanBuilder.checkStackedVlanIdRange(value);
        }
        this._stackedVlanId = value;
        return this;
    }

    public IfStackedVlan build() {
        return new IfStackedVlanImpl(this);
    }

    private static final class IfStackedVlanImpl
    implements IfStackedVlan {
        private final Integer _stackedVlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IfStackedVlan> getImplementedInterface() {
            return IfStackedVlan.class;
        }

        private IfStackedVlanImpl(IfStackedVlanBuilder base) {
            this._stackedVlanId = base.getStackedVlanId();
        }

        @Override
        public Integer getStackedVlanId() {
            return this._stackedVlanId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            this.hash = result = 31 * result + Objects.hashCode(this._stackedVlanId);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IfStackedVlan.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IfStackedVlan other = (IfStackedVlan)obj;
            return Objects.equals(this._stackedVlanId, other.getStackedVlanId());
        }

        public String toString() {
            String name = "IfStackedVlan [";
            StringBuilder builder = new StringBuilder(name);
            if (this._stackedVlanId != null) {
                builder.append("_stackedVlanId=");
                builder.append(this._stackedVlanId);
            }
            return builder.append(']').toString();
        }
    }
}

