/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406;

import java.util.List;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.rev160406.IfMpls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IfMplsBuilder
implements Builder<IfMpls> {
    private List<Long> _labelStack;
    private Short _numLabels;

    public IfMplsBuilder() {
    }

    public IfMplsBuilder(IfMpls base) {
        this._labelStack = base.getLabelStack();
        this._numLabels = base.getNumLabels();
    }

    public List<Long> getLabelStack() {
        return this._labelStack;
    }

    public Short getNumLabels() {
        return this._numLabels;
    }

    public IfMplsBuilder setLabelStack(List<Long> value) {
        this._labelStack = value;
        return this;
    }

    private static void checkNumLabelsRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..7]].", value));
    }

    public IfMplsBuilder setNumLabels(Short value) {
        if (value != null) {
            IfMplsBuilder.checkNumLabelsRange(value);
        }
        this._numLabels = value;
        return this;
    }

    public IfMpls build() {
        return new IfMplsImpl(this);
    }

    private static final class IfMplsImpl
    implements IfMpls {
        private final List<Long> _labelStack;
        private final Short _numLabels;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IfMpls> getImplementedInterface() {
            return IfMpls.class;
        }

        private IfMplsImpl(IfMplsBuilder base) {
            this._labelStack = base.getLabelStack();
            this._numLabels = base.getNumLabels();
        }

        @Override
        public List<Long> getLabelStack() {
            return this._labelStack;
        }

        @Override
        public Short getNumLabels() {
            return this._numLabels;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._labelStack);
            this.hash = result = 31 * result + Objects.hashCode(this._numLabels);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IfMpls.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IfMpls other = (IfMpls)obj;
            if (!Objects.equals(this._labelStack, other.getLabelStack())) {
                return false;
            }
            return Objects.equals(this._numLabels, other.getNumLabels());
        }

        public String toString() {
            String name = "IfMpls [";
            StringBuilder builder = new StringBuilder(name);
            if (this._labelStack != null) {
                builder.append("_labelStack=");
                builder.append(this._labelStack);
                builder.append(", ");
            }
            if (this._numLabels != null) {
                builder.append("_numLabels=");
                builder.append(this._numLabels);
            }
            return builder.append(']').toString();
        }
    }
}

