/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.tunnel.instance._interface.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.tunnel.instance._interface.map.TunnelInstanceInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.tunnel.instance._interface.map.TunnelInstanceInterfaceKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TunnelInstanceInterfaceBuilder
implements Builder<TunnelInstanceInterface> {
    private String _interfaceName;
    private TunnelInstanceInterfaceKey _key;
    private String _tunnelInstanceIdentifier;
    Map<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>> augmentation = Collections.emptyMap();

    public TunnelInstanceInterfaceBuilder() {
    }

    public TunnelInstanceInterfaceBuilder(TunnelInstanceInterface base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TunnelInstanceInterfaceKey(base.getTunnelInstanceIdentifier());
            this._tunnelInstanceIdentifier = base.getTunnelInstanceIdentifier();
        } else {
            this._key = base.getKey();
            this._tunnelInstanceIdentifier = this._key.getTunnelInstanceIdentifier();
        }
        this._interfaceName = base.getInterfaceName();
        if (base instanceof TunnelInstanceInterfaceImpl) {
            TunnelInstanceInterfaceImpl impl = (TunnelInstanceInterfaceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>>(casted.augmentations());
        }
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public TunnelInstanceInterfaceKey getKey() {
        return this._key;
    }

    public String getTunnelInstanceIdentifier() {
        return this._tunnelInstanceIdentifier;
    }

    public <E extends Augmentation<TunnelInstanceInterface>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TunnelInstanceInterfaceBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public TunnelInstanceInterfaceBuilder setKey(TunnelInstanceInterfaceKey value) {
        this._key = value;
        return this;
    }

    public TunnelInstanceInterfaceBuilder setTunnelInstanceIdentifier(String value) {
        this._tunnelInstanceIdentifier = value;
        return this;
    }

    public TunnelInstanceInterfaceBuilder addAugmentation(Class<? extends Augmentation<TunnelInstanceInterface>> augmentationType, Augmentation<TunnelInstanceInterface> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TunnelInstanceInterfaceBuilder removeAugmentation(Class<? extends Augmentation<TunnelInstanceInterface>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TunnelInstanceInterface build() {
        return new TunnelInstanceInterfaceImpl(this);
    }

    private static final class TunnelInstanceInterfaceImpl
    implements TunnelInstanceInterface {
        private final String _interfaceName;
        private final TunnelInstanceInterfaceKey _key;
        private final String _tunnelInstanceIdentifier;
        private Map<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TunnelInstanceInterface> getImplementedInterface() {
            return TunnelInstanceInterface.class;
        }

        private TunnelInstanceInterfaceImpl(TunnelInstanceInterfaceBuilder base) {
            if (base.getKey() == null) {
                this._key = new TunnelInstanceInterfaceKey(base.getTunnelInstanceIdentifier());
                this._tunnelInstanceIdentifier = base.getTunnelInstanceIdentifier();
            } else {
                this._key = base.getKey();
                this._tunnelInstanceIdentifier = this._key.getTunnelInstanceIdentifier();
            }
            this._interfaceName = base.getInterfaceName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>>(base.augmentation);
                }
            }
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public TunnelInstanceInterfaceKey getKey() {
            return this._key;
        }

        @Override
        public String getTunnelInstanceIdentifier() {
            return this._tunnelInstanceIdentifier;
        }

        public <E extends Augmentation<TunnelInstanceInterface>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._tunnelInstanceIdentifier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TunnelInstanceInterface.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TunnelInstanceInterface other = (TunnelInstanceInterface)obj;
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._tunnelInstanceIdentifier, other.getTunnelInstanceIdentifier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TunnelInstanceInterfaceImpl otherImpl = (TunnelInstanceInterfaceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TunnelInstanceInterface>>, Augmentation<TunnelInstanceInterface>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TunnelInstanceInterface [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._tunnelInstanceIdentifier != null) {
                builder.append("_tunnelInstanceIdentifier=");
                builder.append(this._tunnelInstanceIdentifier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

