/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.dpn.to._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.dpn.to._interface.InterfaceNameEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.dpn.to._interface.list.dpn.to._interface.InterfaceNameEntryKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceNameEntryBuilder
implements Builder<InterfaceNameEntry> {
    private String _interfaceName;
    private Class<? extends InterfaceType> _interfaceType;
    private InterfaceNameEntryKey _key;
    Map<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>> augmentation = Collections.emptyMap();

    public InterfaceNameEntryBuilder() {
    }

    public InterfaceNameEntryBuilder(InterfaceNameEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InterfaceNameEntryKey(base.getInterfaceName());
            this._interfaceName = base.getInterfaceName();
        } else {
            this._key = base.getKey();
            this._interfaceName = this._key.getInterfaceName();
        }
        this._interfaceType = base.getInterfaceType();
        if (base instanceof InterfaceNameEntryImpl) {
            InterfaceNameEntryImpl impl = (InterfaceNameEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>>(casted.augmentations());
        }
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public Class<? extends InterfaceType> getInterfaceType() {
        return this._interfaceType;
    }

    public InterfaceNameEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<InterfaceNameEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InterfaceNameEntryBuilder setInterfaceName(String value) {
        this._interfaceName = value;
        return this;
    }

    public InterfaceNameEntryBuilder setInterfaceType(Class<? extends InterfaceType> value) {
        this._interfaceType = value;
        return this;
    }

    public InterfaceNameEntryBuilder setKey(InterfaceNameEntryKey value) {
        this._key = value;
        return this;
    }

    public InterfaceNameEntryBuilder addAugmentation(Class<? extends Augmentation<InterfaceNameEntry>> augmentationType, Augmentation<InterfaceNameEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceNameEntryBuilder removeAugmentation(Class<? extends Augmentation<InterfaceNameEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceNameEntry build() {
        return new InterfaceNameEntryImpl(this);
    }

    private static final class InterfaceNameEntryImpl
    implements InterfaceNameEntry {
        private final String _interfaceName;
        private final Class<? extends InterfaceType> _interfaceType;
        private final InterfaceNameEntryKey _key;
        private Map<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InterfaceNameEntry> getImplementedInterface() {
            return InterfaceNameEntry.class;
        }

        private InterfaceNameEntryImpl(InterfaceNameEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new InterfaceNameEntryKey(base.getInterfaceName());
                this._interfaceName = base.getInterfaceName();
            } else {
                this._key = base.getKey();
                this._interfaceName = this._key.getInterfaceName();
            }
            this._interfaceType = base.getInterfaceType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public String getInterfaceName() {
            return this._interfaceName;
        }

        @Override
        public Class<? extends InterfaceType> getInterfaceType() {
            return this._interfaceType;
        }

        @Override
        public InterfaceNameEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<InterfaceNameEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceName);
            result = 31 * result + Objects.hashCode(this._interfaceType);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceNameEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceNameEntry other = (InterfaceNameEntry)obj;
            if (!Objects.equals(this._interfaceName, other.getInterfaceName())) {
                return false;
            }
            if (!Objects.equals(this._interfaceType, other.getInterfaceType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceNameEntryImpl otherImpl = (InterfaceNameEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceNameEntry>>, Augmentation<InterfaceNameEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InterfaceNameEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._interfaceName != null) {
                builder.append("_interfaceName=");
                builder.append(this._interfaceName);
                builder.append(", ");
            }
            if (this._interfaceType != null) {
                builder.append("_interfaceType=");
                builder.append(this._interfaceType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

