/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.BridgeEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.BridgeEntryKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.meta.rev160406.bridge._interface.info.bridge.entry.BridgeInterfaceEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeEntryBuilder
implements Builder<BridgeEntry> {
    private List<BridgeInterfaceEntry> _bridgeInterfaceEntry;
    private OvsdbBridgeRef _bridgeReference;
    private BigInteger _dpid;
    private BridgeEntryKey _key;
    Map<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKDPIDRANGE_RANGES;

    public BridgeEntryBuilder() {
    }

    public BridgeEntryBuilder(BridgeEntry base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BridgeEntryKey(base.getDpid());
            this._dpid = base.getDpid();
        } else {
            this._key = base.getKey();
            this._dpid = this._key.getDpid();
        }
        this._bridgeInterfaceEntry = base.getBridgeInterfaceEntry();
        this._bridgeReference = base.getBridgeReference();
        if (base instanceof BridgeEntryImpl) {
            BridgeEntryImpl impl = (BridgeEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>>(casted.augmentations());
        }
    }

    public List<BridgeInterfaceEntry> getBridgeInterfaceEntry() {
        return this._bridgeInterfaceEntry;
    }

    public OvsdbBridgeRef getBridgeReference() {
        return this._bridgeReference;
    }

    public BigInteger getDpid() {
        return this._dpid;
    }

    public BridgeEntryKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BridgeEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeEntryBuilder setBridgeInterfaceEntry(List<BridgeInterfaceEntry> value) {
        this._bridgeInterfaceEntry = value;
        return this;
    }

    public BridgeEntryBuilder setBridgeReference(OvsdbBridgeRef value) {
        this._bridgeReference = value;
        return this;
    }

    private static void checkDpidRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKDPIDRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKDPIDRANGE_RANGES)));
    }

    public BridgeEntryBuilder setDpid(BigInteger value) {
        if (value != null) {
            BridgeEntryBuilder.checkDpidRange(value);
        }
        this._dpid = value;
        return this;
    }

    public BridgeEntryBuilder setKey(BridgeEntryKey value) {
        this._key = value;
        return this;
    }

    public BridgeEntryBuilder addAugmentation(Class<? extends Augmentation<BridgeEntry>> augmentationType, Augmentation<BridgeEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeEntryBuilder removeAugmentation(Class<? extends Augmentation<BridgeEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeEntry build() {
        return new BridgeEntryImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKDPIDRANGE_RANGES = a;
    }

    private static final class BridgeEntryImpl
    implements BridgeEntry {
        private final List<BridgeInterfaceEntry> _bridgeInterfaceEntry;
        private final OvsdbBridgeRef _bridgeReference;
        private final BigInteger _dpid;
        private final BridgeEntryKey _key;
        private Map<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BridgeEntry> getImplementedInterface() {
            return BridgeEntry.class;
        }

        private BridgeEntryImpl(BridgeEntryBuilder base) {
            if (base.getKey() == null) {
                this._key = new BridgeEntryKey(base.getDpid());
                this._dpid = base.getDpid();
            } else {
                this._key = base.getKey();
                this._dpid = this._key.getDpid();
            }
            this._bridgeInterfaceEntry = base.getBridgeInterfaceEntry();
            this._bridgeReference = base.getBridgeReference();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BridgeInterfaceEntry> getBridgeInterfaceEntry() {
            return this._bridgeInterfaceEntry;
        }

        @Override
        public OvsdbBridgeRef getBridgeReference() {
            return this._bridgeReference;
        }

        @Override
        public BigInteger getDpid() {
            return this._dpid;
        }

        @Override
        public BridgeEntryKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BridgeEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeInterfaceEntry);
            result = 31 * result + Objects.hashCode(this._bridgeReference);
            result = 31 * result + Objects.hashCode(this._dpid);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BridgeEntry other = (BridgeEntry)obj;
            if (!Objects.equals(this._bridgeInterfaceEntry, other.getBridgeInterfaceEntry())) {
                return false;
            }
            if (!Objects.equals(this._bridgeReference, other.getBridgeReference())) {
                return false;
            }
            if (!Objects.equals(this._dpid, other.getDpid())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeEntryImpl otherImpl = (BridgeEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BridgeEntry>>, Augmentation<BridgeEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BridgeEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeInterfaceEntry != null) {
                builder.append("_bridgeInterfaceEntry=");
                builder.append(this._bridgeInterfaceEntry);
                builder.append(", ");
            }
            if (this._bridgeReference != null) {
                builder.append("_bridgeReference=");
                builder.append(this._bridgeReference);
                builder.append(", ");
            }
            if (this._dpid != null) {
                builder.append("_dpid=");
                builder.append(this._dpid);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

