/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.config.rev160406;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius.interfacemanager.config.rev160406.IfmConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IfmConfigBuilder
implements Builder<IfmConfig> {
    private Integer _ifmStatsDefPollInterval;
    private Boolean _ifmStatsPollEnabled;
    private Boolean _itmDirectTunnels;
    Map<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>> augmentation = Collections.emptyMap();

    public IfmConfigBuilder() {
    }

    public IfmConfigBuilder(IfmConfig base) {
        AugmentationHolder casted;
        this._ifmStatsDefPollInterval = base.getIfmStatsDefPollInterval();
        this._ifmStatsPollEnabled = base.isIfmStatsPollEnabled();
        this._itmDirectTunnels = base.isItmDirectTunnels();
        if (base instanceof IfmConfigImpl) {
            IfmConfigImpl impl = (IfmConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>>(casted.augmentations());
        }
    }

    public Integer getIfmStatsDefPollInterval() {
        return this._ifmStatsDefPollInterval;
    }

    public Boolean isIfmStatsPollEnabled() {
        return this._ifmStatsPollEnabled;
    }

    public Boolean isItmDirectTunnels() {
        return this._itmDirectTunnels;
    }

    public <E extends Augmentation<IfmConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIfmStatsDefPollIntervalRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public IfmConfigBuilder setIfmStatsDefPollInterval(Integer value) {
        if (value != null) {
            IfmConfigBuilder.checkIfmStatsDefPollIntervalRange(value);
        }
        this._ifmStatsDefPollInterval = value;
        return this;
    }

    public IfmConfigBuilder setIfmStatsPollEnabled(Boolean value) {
        this._ifmStatsPollEnabled = value;
        return this;
    }

    public IfmConfigBuilder setItmDirectTunnels(Boolean value) {
        this._itmDirectTunnels = value;
        return this;
    }

    public IfmConfigBuilder addAugmentation(Class<? extends Augmentation<IfmConfig>> augmentationType, Augmentation<IfmConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IfmConfigBuilder removeAugmentation(Class<? extends Augmentation<IfmConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IfmConfig build() {
        return new IfmConfigImpl(this);
    }

    private static final class IfmConfigImpl
    implements IfmConfig {
        private final Integer _ifmStatsDefPollInterval;
        private final Boolean _ifmStatsPollEnabled;
        private final Boolean _itmDirectTunnels;
        private Map<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IfmConfig> getImplementedInterface() {
            return IfmConfig.class;
        }

        private IfmConfigImpl(IfmConfigBuilder base) {
            this._ifmStatsDefPollInterval = base.getIfmStatsDefPollInterval();
            this._ifmStatsPollEnabled = base.isIfmStatsPollEnabled();
            this._itmDirectTunnels = base.isItmDirectTunnels();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getIfmStatsDefPollInterval() {
            return this._ifmStatsDefPollInterval;
        }

        @Override
        public Boolean isIfmStatsPollEnabled() {
            return this._ifmStatsPollEnabled;
        }

        @Override
        public Boolean isItmDirectTunnels() {
            return this._itmDirectTunnels;
        }

        public <E extends Augmentation<IfmConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ifmStatsDefPollInterval);
            result = 31 * result + Objects.hashCode(this._ifmStatsPollEnabled);
            result = 31 * result + Objects.hashCode(this._itmDirectTunnels);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IfmConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IfmConfig other = (IfmConfig)obj;
            if (!Objects.equals(this._ifmStatsDefPollInterval, other.getIfmStatsDefPollInterval())) {
                return false;
            }
            if (!Objects.equals(this._ifmStatsPollEnabled, other.isIfmStatsPollEnabled())) {
                return false;
            }
            if (!Objects.equals(this._itmDirectTunnels, other.isItmDirectTunnels())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IfmConfigImpl otherImpl = (IfmConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IfmConfig>>, Augmentation<IfmConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "IfmConfig [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ifmStatsDefPollInterval != null) {
                builder.append("_ifmStatsDefPollInterval=");
                builder.append(this._ifmStatsDefPollInterval);
                builder.append(", ");
            }
            if (this._ifmStatsPollEnabled != null) {
                builder.append("_ifmStatsPollEnabled=");
                builder.append(this._ifmStatsPollEnabled);
                builder.append(", ");
            }
            if (this._itmDirectTunnels != null) {
                builder.append("_itmDirectTunnels=");
                builder.append(this._itmDirectTunnels);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

