/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.get._interface.statistics.output;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.ResultCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.ServiceEnitityStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.StatReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.get._interface.statistics.output.StatResult;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatResultBuilder
implements Builder<StatResult> {
    private Long _byteRxCount;
    private Long _byteTxCount;
    private Long _packetRxCount;
    private Long _packetTxCount;
    private ResultCode _statResultCode;
    Map<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>> augmentation = Collections.emptyMap();

    public StatResultBuilder() {
    }

    public StatResultBuilder(StatReply arg) {
        this._statResultCode = arg.getStatResultCode();
        this._packetTxCount = arg.getPacketTxCount();
        this._packetRxCount = arg.getPacketRxCount();
        this._byteTxCount = arg.getByteTxCount();
        this._byteRxCount = arg.getByteRxCount();
    }

    public StatResultBuilder(ServiceEnitityStatistics arg) {
        this._packetTxCount = arg.getPacketTxCount();
        this._packetRxCount = arg.getPacketRxCount();
        this._byteTxCount = arg.getByteTxCount();
        this._byteRxCount = arg.getByteRxCount();
    }

    public StatResultBuilder(StatResult base) {
        AugmentationHolder casted;
        this._byteRxCount = base.getByteRxCount();
        this._byteTxCount = base.getByteTxCount();
        this._packetRxCount = base.getPacketRxCount();
        this._packetTxCount = base.getPacketTxCount();
        this._statResultCode = base.getStatResultCode();
        if (base instanceof StatResultImpl) {
            StatResultImpl impl = (StatResultImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceEnitityStatistics) {
            this._packetTxCount = ((ServiceEnitityStatistics)arg).getPacketTxCount();
            this._packetRxCount = ((ServiceEnitityStatistics)arg).getPacketRxCount();
            this._byteTxCount = ((ServiceEnitityStatistics)arg).getByteTxCount();
            this._byteRxCount = ((ServiceEnitityStatistics)arg).getByteRxCount();
            isValidArg = true;
        }
        if (arg instanceof StatReply) {
            this._statResultCode = ((StatReply)arg).getStatResultCode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.ServiceEnitityStatistics, org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824.StatReply] \nbut was: " + arg);
        }
    }

    public Long getByteRxCount() {
        return this._byteRxCount;
    }

    public Long getByteTxCount() {
        return this._byteTxCount;
    }

    public Long getPacketRxCount() {
        return this._packetRxCount;
    }

    public Long getPacketTxCount() {
        return this._packetTxCount;
    }

    public ResultCode getStatResultCode() {
        return this._statResultCode;
    }

    public <E extends Augmentation<StatResult>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteRxCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatResultBuilder setByteRxCount(Long value) {
        if (value != null) {
            StatResultBuilder.checkByteRxCountRange(value);
        }
        this._byteRxCount = value;
        return this;
    }

    private static void checkByteTxCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatResultBuilder setByteTxCount(Long value) {
        if (value != null) {
            StatResultBuilder.checkByteTxCountRange(value);
        }
        this._byteTxCount = value;
        return this;
    }

    private static void checkPacketRxCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatResultBuilder setPacketRxCount(Long value) {
        if (value != null) {
            StatResultBuilder.checkPacketRxCountRange(value);
        }
        this._packetRxCount = value;
        return this;
    }

    private static void checkPacketTxCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatResultBuilder setPacketTxCount(Long value) {
        if (value != null) {
            StatResultBuilder.checkPacketTxCountRange(value);
        }
        this._packetTxCount = value;
        return this;
    }

    public StatResultBuilder setStatResultCode(ResultCode value) {
        this._statResultCode = value;
        return this;
    }

    public StatResultBuilder addAugmentation(Class<? extends Augmentation<StatResult>> augmentationType, Augmentation<StatResult> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StatResultBuilder removeAugmentation(Class<? extends Augmentation<StatResult>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StatResult build() {
        return new StatResultImpl(this);
    }

    private static final class StatResultImpl
    implements StatResult {
        private final Long _byteRxCount;
        private final Long _byteTxCount;
        private final Long _packetRxCount;
        private final Long _packetTxCount;
        private final ResultCode _statResultCode;
        private Map<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StatResult> getImplementedInterface() {
            return StatResult.class;
        }

        private StatResultImpl(StatResultBuilder base) {
            this._byteRxCount = base.getByteRxCount();
            this._byteTxCount = base.getByteTxCount();
            this._packetRxCount = base.getPacketRxCount();
            this._packetTxCount = base.getPacketTxCount();
            this._statResultCode = base.getStatResultCode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getByteRxCount() {
            return this._byteRxCount;
        }

        @Override
        public Long getByteTxCount() {
            return this._byteTxCount;
        }

        @Override
        public Long getPacketRxCount() {
            return this._packetRxCount;
        }

        @Override
        public Long getPacketTxCount() {
            return this._packetTxCount;
        }

        @Override
        public ResultCode getStatResultCode() {
            return this._statResultCode;
        }

        public <E extends Augmentation<StatResult>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteRxCount);
            result = 31 * result + Objects.hashCode(this._byteTxCount);
            result = 31 * result + Objects.hashCode(this._packetRxCount);
            result = 31 * result + Objects.hashCode(this._packetTxCount);
            result = 31 * result + Objects.hashCode((Object)this._statResultCode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StatResult.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StatResult other = (StatResult)obj;
            if (!Objects.equals(this._byteRxCount, other.getByteRxCount())) {
                return false;
            }
            if (!Objects.equals(this._byteTxCount, other.getByteTxCount())) {
                return false;
            }
            if (!Objects.equals(this._packetRxCount, other.getPacketRxCount())) {
                return false;
            }
            if (!Objects.equals(this._packetTxCount, other.getPacketTxCount())) {
                return false;
            }
            if (!Objects.equals((Object)this._statResultCode, (Object)other.getStatResultCode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatResultImpl otherImpl = (StatResultImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StatResult>>, Augmentation<StatResult>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "StatResult [";
            StringBuilder builder = new StringBuilder(name);
            if (this._byteRxCount != null) {
                builder.append("_byteRxCount=");
                builder.append(this._byteRxCount);
                builder.append(", ");
            }
            if (this._byteTxCount != null) {
                builder.append("_byteTxCount=");
                builder.append(this._byteTxCount);
                builder.append(", ");
            }
            if (this._packetRxCount != null) {
                builder.append("_packetRxCount=");
                builder.append(this._packetRxCount);
                builder.append(", ");
            }
            if (this._packetTxCount != null) {
                builder.append("_packetTxCount=");
                builder.append(this._packetTxCount);
                builder.append(", ");
            }
            if (this._statResultCode != null) {
                builder.append("_statResultCode=");
                builder.append((Object)this._statResultCode);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

