/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.genius._interface.statistics.rev150824;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ResultCode {
    NotFound(0, "not-found"),
    Success(1, "success"),
    Incomplete(2, "incomplete");

    private static final Map<Integer, ResultCode> VALUE_MAP;
    private final String name;
    private final int value;

    private ResultCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static ResultCode forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (ResultCode enumItem : ResultCode.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

