/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;

public final class StringUtil {
    private StringUtil() {
        throw new UnsupportedOperationException();
    }

    public static String prefixAndJoin(List<FullyQualifiedName> list, String prefix) {
        if (list.isEmpty()) {
            return "";
        }
        Joiner joiner = Joiner.on((String)",");
        return " " + prefix + " " + joiner.join(list);
    }

    public static String addAsterixAtEachLineStart(String input) {
        String s = Pattern.compile("^", 8).matcher(input).replaceAll("* ");
        s = Pattern.compile("\\s+$", 8).matcher(s).replaceAll("");
        s = StringUtil.ensureEndsWithSingleNewLine(s);
        return s;
    }

    private static String ensureEndsWithSingleNewLine(String s) {
        Object[] split = s.split("\n");
        s = Joiner.on((String)"\n").join(split);
        s = s + "\n";
        return s;
    }

    public static String writeComment(String input, boolean isJavadoc) {
        StringBuilder content = new StringBuilder();
        content.append("/*");
        if (isJavadoc) {
            content.append("*");
        }
        content.append("\n");
        content.append(StringUtil.addAsterixAtEachLineStart(input));
        content.append("*/\n");
        return content.toString();
    }

    public static Optional<String> loadCopyright() {
        return Optional.absent();
    }

    public static String formatJavaSource(String input) {
        Iterable split = Splitter.on((String)"\n").trimResults().split((CharSequence)input);
        int basicIndent = 4;
        StringBuilder sb = new StringBuilder();
        int indents = 0;
        int empty = 0;
        for (String line : split) {
            if ((indents -= StringUtils.countMatches((CharSequence)line, (CharSequence)"}")) < 0) {
                indents = 0;
            }
            if (!line.isEmpty()) {
                sb.append(Strings.repeat((String)" ", (int)(basicIndent * indents)));
                sb.append(line);
                sb.append("\n");
                empty = 0;
            } else if (++empty < 2) {
                sb.append("\n");
            }
            indents += StringUtils.countMatches((CharSequence)line, (CharSequence)"{");
        }
        return StringUtil.ensureEndsWithSingleNewLine(sb.toString());
    }
}

