/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.java;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInput;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.TypeName;

public class JavaFileInputBuilder {
    private Optional<String> copyright = Optional.absent();
    private Optional<String> header = Optional.absent();
    private Optional<String> classJavaDoc = Optional.absent();
    private TypeName typeName = TypeName.classType;
    private FullyQualifiedName fqn;
    private final List<String> classAnnotations = new ArrayList<String>();
    private final List<FullyQualifiedName> importFQNs = new ArrayList<FullyQualifiedName>();
    private final List<FullyQualifiedName> extendsFQNs = new ArrayList<FullyQualifiedName>();
    private final List<FullyQualifiedName> implementsFQNs = new ArrayList<FullyQualifiedName>();
    private final List<String> bodyElements = new ArrayList<String>();

    public void addToBody(String element) {
        this.bodyElements.add(element + "\n");
    }

    public void addClassAnnotation(Annotation annotation) {
        this.addClassAnnotation(annotation.toString());
    }

    public void addClassAnnotation(String annotation) {
        this.classAnnotations.add((String)Preconditions.checkNotNull((Object)annotation));
    }

    public void addImportFQN(FullyQualifiedName fqn) {
        this.importFQNs.add(fqn);
    }

    public void addExtendsFQN(FullyQualifiedName fqn) {
        this.extendsFQNs.add(fqn);
    }

    public void addImplementsFQN(FullyQualifiedName fqn) {
        this.implementsFQNs.add(fqn);
    }

    public Optional<String> getCopyright() {
        return this.copyright;
    }

    public void setCopyright(Optional<String> copyright) {
        this.copyright = (Optional)Preconditions.checkNotNull(copyright);
    }

    public Optional<String> getHeader() {
        return this.header;
    }

    public void setHeader(Optional<String> header) {
        this.header = (Optional)Preconditions.checkNotNull(header);
    }

    public Optional<String> getClassJavaDoc() {
        return this.classJavaDoc;
    }

    public void setClassJavaDoc(Optional<String> classJavaDoc) {
        this.classJavaDoc = (Optional)Preconditions.checkNotNull(classJavaDoc);
    }

    public FullyQualifiedName getFqn() {
        return this.fqn;
    }

    public void setFqn(FullyQualifiedName fqn) {
        this.fqn = fqn;
    }

    public List<FullyQualifiedName> getExtendsFQNs() {
        return this.extendsFQNs;
    }

    public List<FullyQualifiedName> getImplementsFQNs() {
        return this.implementsFQNs;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(TypeName typeName) {
        this.typeName = typeName;
    }

    public JavaFileInput build() {
        Preconditions.checkNotNull(this.copyright);
        Preconditions.checkNotNull(this.header);
        Preconditions.checkNotNull(this.classJavaDoc);
        Preconditions.checkNotNull((Object)((Object)this.typeName));
        Preconditions.checkNotNull((Object)this.fqn);
        return new JavaFileInput(){

            @Override
            public FullyQualifiedName getFQN() {
                return JavaFileInputBuilder.this.fqn;
            }

            @Override
            public Optional<String> getCopyright() {
                return JavaFileInputBuilder.this.copyright;
            }

            @Override
            public Optional<String> getHeader() {
                return JavaFileInputBuilder.this.header;
            }

            @Override
            public List<FullyQualifiedName> getImports() {
                return Collections.unmodifiableList(JavaFileInputBuilder.this.importFQNs);
            }

            @Override
            public Optional<String> getClassJavaDoc() {
                return JavaFileInputBuilder.this.classJavaDoc;
            }

            @Override
            public TypeName getType() {
                return JavaFileInputBuilder.this.typeName;
            }

            @Override
            public List<FullyQualifiedName> getExtends() {
                return Collections.unmodifiableList(JavaFileInputBuilder.this.extendsFQNs);
            }

            @Override
            public List<FullyQualifiedName> getImplements() {
                return Collections.unmodifiableList(JavaFileInputBuilder.this.implementsFQNs);
            }

            @Override
            public List<String> getClassAnnotations() {
                return Collections.unmodifiableList(JavaFileInputBuilder.this.classAnnotations);
            }

            @Override
            public List<String> getBodyElements() {
                return Collections.unmodifiableList(JavaFileInputBuilder.this.bodyElements);
            }
        };
    }
}

