/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.FieldSerializer;

public class Field {
    private final String type;
    private final String name;
    private final String definition;
    private final List<Modifier> modifiers;
    private final boolean needsDepResolver;

    public Field(String type, String name) {
        this(new ArrayList<Modifier>(), type, name, null, false);
    }

    public Field(String type, String name, String definition) {
        this(new ArrayList<Modifier>(), type, name, definition, false);
    }

    public Field(List<Modifier> modifiers, String type, String name) {
        this(modifiers, type, name, null, false);
    }

    public Field(List<Modifier> modifiers, String type, String name, String definition) {
        this(modifiers, type, name, definition, false);
    }

    public Field(List<Modifier> modifiers, String type, String name, String nullableDefinition, boolean needsDepResolver) {
        this.modifiers = (List)Preconditions.checkNotNull(modifiers);
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.definition = nullableDefinition;
        this.needsDepResolver = needsDepResolver;
    }

    public Field(String type, String name, String definition, boolean needsDepResolver) {
        this(new ArrayList<Modifier>(), type, name, definition, needsDepResolver);
    }

    public boolean isNeedsDepResolver() {
        return this.needsDepResolver;
    }

    public String getType() {
        return this.type;
    }

    public String getGenericInnerType() {
        return this.type.substring(this.type.indexOf("<") + 1, this.type.indexOf(">"));
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public boolean isArray() {
        return this.type.endsWith("[]");
    }

    public String toString() {
        return FieldSerializer.toString(this);
    }
}

