/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives;

import com.google.common.collect.Lists;
import freemarker.core.Environment;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralClassTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Constructor;

public class ConstructorsDirective
implements TemplateDirectiveModel {
    private static final String OBJECT = "object";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Object object = params.get(OBJECT);
        List<Object> constructors = Lists.newArrayList();
        if (object != null) {
            if (object instanceof SimpleSequence) {
                constructors = ((SimpleSequence)object).toList();
            } else if (object instanceof GeneralClassTemplate) {
                constructors = ((GeneralClassTemplate)object).getConstructors();
            } else {
                throw new IllegalArgumentException("Object must be a SimpleSequence or instance of " + GeneralClassTemplate.class + "but was " + object.getClass());
            }
        }
        Writer out = env.getOut();
        StringBuilder build = new StringBuilder();
        for (Constructor constructor : constructors) {
            build.append("    ");
            if (constructor.isPublic()) {
                build.append("public ");
            }
            build.append(constructor.getTypeName() + " ");
            build.append("() {");
            build.append(System.lineSeparator());
            build.append("    ");
            build.append("    ");
            build.append(constructor.getBody());
            build.append(System.lineSeparator());
            build.append("    ");
            build.append("}");
            build.append(System.lineSeparator());
            build.append(System.lineSeparator());
        }
        if (!constructors.isEmpty()) {
            out.write(build.toString().toCharArray());
        }
    }
}

