/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.common.impl.AbstractDataModification;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractDataTransaction<P extends Path<P>, D>
extends AbstractDataModification<P, D> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataTransaction.class);
    private static final ListenableFuture<RpcResult<TransactionStatus>> SUCCESS_FUTURE = Futures.immediateFuture((Object)RpcResultBuilder.success((Object)TransactionStatus.COMMITED).build());
    private final Object identifier;
    private final long allocationTime;
    private long readyTime = 0L;
    private long completeTime = 0L;
    private TransactionStatus status = TransactionStatus.NEW;
    private final AbstractDataBroker<P, D, ? extends Object> broker;

    protected AbstractDataTransaction(Object identifier, AbstractDataBroker<P, D, ? extends Object> dataBroker) {
        super(dataBroker);
        this.identifier = Preconditions.checkNotNull((Object)identifier);
        this.broker = (AbstractDataBroker)Preconditions.checkNotNull(dataBroker);
        this.allocationTime = System.nanoTime();
        LOG.debug("Transaction {} Allocated.", identifier);
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public Future<RpcResult<TransactionStatus>> commit() {
        this.readyTime = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction {} Ready after {}ms.", this.identifier, (Object)TimeUnit.NANOSECONDS.toMillis(this.readyTime - this.allocationTime));
        }
        this.changeStatus(TransactionStatus.SUBMITED);
        return this.broker.commit(this);
    }

    @Override
    public D readConfigurationData(P path) {
        Object local = this.getUpdatedConfigurationData().get(path);
        if (local != null) {
            return local;
        }
        return this.broker.readConfigurationData(path);
    }

    @Override
    public D readOperationalData(P path) {
        Object local = this.getUpdatedOperationalData().get(path);
        if (local != null) {
            return local;
        }
        return this.broker.readOperationalData(path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataTransaction other = (AbstractDataTransaction)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    protected abstract void onStatusChange(TransactionStatus var1);

    public void succeeded() {
        this.completeTime = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction {} Committed after {}ms.", this.identifier, (Object)TimeUnit.NANOSECONDS.toMillis(this.completeTime - this.readyTime));
        }
        this.changeStatus(TransactionStatus.COMMITED);
    }

    public void failed() {
        this.completeTime = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction {} Failed after {}ms.", this.identifier, (Object)TimeUnit.NANOSECONDS.toMillis(this.completeTime - this.readyTime));
        }
        this.changeStatus(TransactionStatus.FAILED);
    }

    private void changeStatus(TransactionStatus status) {
        LOG.debug("Transaction {} transitioned from {} to {}", new Object[]{this.getIdentifier(), this.status, status});
        this.status = status;
        this.onStatusChange(status);
    }

    public static ListenableFuture<RpcResult<TransactionStatus>> convertToLegacyCommitFuture(CheckedFuture<Void, TransactionCommitFailedException> from) {
        return Futures.transform(from, (AsyncFunction)new AsyncFunction<Void, RpcResult<TransactionStatus>>(){

            public ListenableFuture<RpcResult<TransactionStatus>> apply(Void input) {
                return SUCCESS_FUTURE;
            }
        });
    }
}

