/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opendaylight.controller.md.sal.common.api.RegistrationListener;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.DataChangePublisher;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandlerRegistration;
import org.opendaylight.controller.md.sal.common.api.data.DataModificationTransactionFactory;
import org.opendaylight.controller.md.sal.common.api.data.DataProvisionService;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.impl.routing.AbstractDataReadRouter;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.common.impl.service.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.common.impl.service.InitialDataChangeEventImpl;
import org.opendaylight.controller.md.sal.common.impl.service.ListenerStateCapture;
import org.opendaylight.controller.md.sal.common.impl.service.TwoPhaseCommit;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.CompositeObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractDataBroker<P extends Path<P>, D, DCL extends DataChangeListener<P, D>>
implements DataModificationTransactionFactory<P, D>,
DataReader<P, D>,
DataChangePublisher<P, D, DCL>,
DataProvisionService<P, D> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataBroker.class);
    private ExecutorService executor;
    private ExecutorService notificationExecutor = MoreExecutors.sameThreadExecutor();
    private AbstractDataReadRouter<P, D> dataReadRouter;
    private final AtomicLong submittedTransactionsCount = new AtomicLong();
    private final AtomicLong failedTransactionsCount = new AtomicLong();
    private final AtomicLong finishedTransactionsCount = new AtomicLong();
    private final Multimap<P, DataChangeListenerRegistration<P, D, DCL>> listeners = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final Multimap<P, DataCommitHandlerRegistrationImpl<P, D>> commitHandlers = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final Lock registrationLock = new ReentrantLock();
    private final ListenerRegistry<RegistrationListener<DataCommitHandlerRegistration<P, D>>> commitHandlerRegistrationListeners = new ListenerRegistry();

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public ExecutorService getNotificationExecutor() {
        return this.notificationExecutor;
    }

    public void setNotificationExecutor(ExecutorService notificationExecutor) {
        this.notificationExecutor = notificationExecutor;
    }

    public AbstractDataReadRouter<P, D> getDataReadRouter() {
        return this.dataReadRouter;
    }

    public void setDataReadRouter(AbstractDataReadRouter<P, D> dataReadRouter) {
        this.dataReadRouter = dataReadRouter;
    }

    public AtomicLong getSubmittedTransactionsCount() {
        return this.submittedTransactionsCount;
    }

    public AtomicLong getFailedTransactionsCount() {
        return this.failedTransactionsCount;
    }

    public AtomicLong getFinishedTransactionsCount() {
        return this.finishedTransactionsCount;
    }

    protected ImmutableList<DataCommitHandler<P, D>> affectedCommitHandlers(final Set<P> paths) {
        Supplier _function = new Supplier<ImmutableList<DataCommitHandler<P, D>>>(){

            public ImmutableList<DataCommitHandler<P, D>> get() {
                Map _asMap = AbstractDataBroker.this.commitHandlers.asMap();
                Set _entrySet = _asMap.entrySet();
                FluentIterable _from = FluentIterable.from(_entrySet);
                Predicate _function = new Predicate<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>>(){

                    public boolean apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                        Path _key = (Path)it.getKey();
                        boolean _isAffectedBy = AbstractDataBroker.this.isAffectedBy(_key, paths);
                        return _isAffectedBy;
                    }
                };
                FluentIterable _filter = _from.filter(_function);
                Function _function_1 = new Function<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>, Collection<DataCommitHandlerRegistrationImpl<P, D>>>(){

                    public Collection<DataCommitHandlerRegistrationImpl<P, D>> apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                        Collection _value = it.getValue();
                        return _value;
                    }
                };
                FluentIterable _transformAndConcat = _filter.transformAndConcat(_function_1);
                Function _function_2 = new Function<DataCommitHandlerRegistrationImpl<P, D>, DataCommitHandler<P, D>>(){

                    public DataCommitHandler<P, D> apply(DataCommitHandlerRegistrationImpl<P, D> it) {
                        DataCommitHandler _instance = (DataCommitHandler)it.getInstance();
                        return _instance;
                    }
                };
                FluentIterable _transform = _transformAndConcat.transform(_function_2);
                return _transform.toList();
            }
        };
        return (ImmutableList)AbstractDataBroker.withLock(this.registrationLock, _function);
    }

    protected ImmutableList<DataCommitHandler<P, D>> probablyAffectedCommitHandlers(final HashSet<P> paths) {
        Supplier _function = new Supplier<ImmutableList<DataCommitHandler<P, D>>>(){

            public ImmutableList<DataCommitHandler<P, D>> get() {
                Map _asMap = AbstractDataBroker.this.commitHandlers.asMap();
                Set _entrySet = _asMap.entrySet();
                FluentIterable _from = FluentIterable.from(_entrySet);
                Predicate _function = new Predicate<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>>(){

                    public boolean apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                        Path _key = (Path)it.getKey();
                        boolean _isProbablyAffectedBy = AbstractDataBroker.this.isProbablyAffectedBy(_key, paths);
                        return _isProbablyAffectedBy;
                    }
                };
                FluentIterable _filter = _from.filter(_function);
                Function _function_1 = new Function<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>, Collection<DataCommitHandlerRegistrationImpl<P, D>>>(){

                    public Collection<DataCommitHandlerRegistrationImpl<P, D>> apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                        Collection _value = it.getValue();
                        return _value;
                    }
                };
                FluentIterable _transformAndConcat = _filter.transformAndConcat(_function_1);
                Function _function_2 = new Function<DataCommitHandlerRegistrationImpl<P, D>, DataCommitHandler<P, D>>(){

                    public DataCommitHandler<P, D> apply(DataCommitHandlerRegistrationImpl<P, D> it) {
                        DataCommitHandler _instance = (DataCommitHandler)it.getInstance();
                        return _instance;
                    }
                };
                FluentIterable _transform = _transformAndConcat.transform(_function_2);
                return _transform.toList();
            }
        };
        return (ImmutableList)AbstractDataBroker.withLock(this.registrationLock, _function);
    }

    protected Map<P, D> deepGetBySubpath(Map<P, D> dataSet, P path) {
        return Collections.emptyMap();
    }

    public final D readConfigurationData(P path) {
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        return _dataReadRouter.readConfigurationData(path);
    }

    public final D readOperationalData(P path) {
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        return _dataReadRouter.readOperationalData(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withLock(Lock lock, Supplier<T> method) {
        lock.lock();
        try {
            Object object = method.get();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Registration registerCommitHandler(P path, DataCommitHandler<P, D> commitHandler) {
        DataCommitHandler<P, D> dataCommitHandler = commitHandler;
        synchronized (dataCommitHandler) {
            DataCommitHandlerRegistrationImpl<P, D> registration = new DataCommitHandlerRegistrationImpl<P, D>(path, commitHandler, this);
            this.commitHandlers.put(path, registration);
            LOG.trace("Registering Commit Handler {} for path: {}", commitHandler, path);
            for (ListenerRegistration listener : this.commitHandlerRegistrationListeners) {
                try {
                    ((RegistrationListener)listener.getInstance()).onRegister(registration);
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception in listener {} during invoking onRegister", listener.getInstance(), (Object)e);
                }
            }
            return registration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ListenerRegistration<DCL> registerDataChangeListener(P path, DCL listener) {
        Multimap<P, DataChangeListenerRegistration<P, D, DCL>> multimap = this.listeners;
        synchronized (multimap) {
            DataChangeListenerRegistration reg = new DataChangeListenerRegistration(path, listener, this);
            this.listeners.put(path, reg);
            D initialConfig = this.getDataReadRouter().readConfigurationData(path);
            D initialOperational = this.getDataReadRouter().readOperationalData(path);
            DataChangeEvent<P, D> event = this.createInitialListenerEvent(path, initialConfig, initialOperational);
            listener.onDataChanged(event);
            return reg;
        }
    }

    public final CompositeObjectRegistration<DataReader<P, D>> registerDataReader(P path, DataReader<P, D> reader) {
        Registration confReg = this.getDataReadRouter().registerConfigurationReader(path, reader);
        Registration dataReg = this.getDataReadRouter().registerOperationalReader(path, reader);
        return new CompositeObjectRegistration(reader, Arrays.asList(confReg, dataReg));
    }

    public ListenerRegistration<RegistrationListener<DataCommitHandlerRegistration<P, D>>> registerCommitHandlerListener(RegistrationListener<DataCommitHandlerRegistration<P, D>> commitHandlerListener) {
        ListenerRegistration ret = this.commitHandlerRegistrationListeners.register(commitHandlerListener);
        return ret;
    }

    protected DataChangeEvent<P, D> createInitialListenerEvent(P path, D initialConfig, D initialOperational) {
        InitialDataChangeEventImpl _initialDataChangeEventImpl = new InitialDataChangeEventImpl(initialConfig, initialOperational);
        return _initialDataChangeEventImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeListener(DataChangeListenerRegistration<P, D, DCL> registration) {
        Multimap<P, DataChangeListenerRegistration<P, D, DCL>> multimap = this.listeners;
        synchronized (multimap) {
            this.listeners.remove(registration.getPath(), registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeCommitHandler(DataCommitHandlerRegistrationImpl<P, D> registration) {
        Multimap<P, DataCommitHandlerRegistrationImpl<P, D>> multimap = this.commitHandlers;
        synchronized (multimap) {
            this.commitHandlers.remove(registration.getPath(), registration);
            LOG.trace("Removing Commit Handler {} for path: {}", registration.getInstance(), registration.getPath());
            for (ListenerRegistration listener : this.commitHandlerRegistrationListeners) {
                try {
                    ((RegistrationListener)listener.getInstance()).onUnregister(registration);
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception in listener {} during invoking onUnregister", listener.getInstance(), (Object)e);
                }
            }
        }
    }

    protected final Collection<Map.Entry<P, DataCommitHandlerRegistrationImpl<P, D>>> getActiveCommitHandlers() {
        return this.commitHandlers.entries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImmutableList<ListenerStateCapture<P, D, DCL>> affectedListeners(final Set<P> paths) {
        Multimap<P, DataChangeListenerRegistration<P, D, DCL>> multimap = this.listeners;
        synchronized (multimap) {
            return FluentIterable.from(this.listeners.asMap().entrySet()).filter(new Predicate<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>>(){

                public boolean apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                    return AbstractDataBroker.this.isAffectedBy((Path)it.getKey(), paths);
                }
            }).transform(new Function<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>, ListenerStateCapture<P, D, DCL>>(){

                public ListenerStateCapture<P, D, DCL> apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                    return new ListenerStateCapture((Path)it.getKey(), it.getValue(), AbstractDataBroker.this.createContainsPredicate((Path)it.getKey()));
                }
            }).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImmutableList<ListenerStateCapture<P, D, DCL>> probablyAffectedListeners(final Set<P> paths) {
        Multimap<P, DataChangeListenerRegistration<P, D, DCL>> multimap = this.listeners;
        synchronized (multimap) {
            return FluentIterable.from(this.listeners.asMap().entrySet()).filter(new Predicate<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>>(){

                public boolean apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                    return AbstractDataBroker.this.isProbablyAffectedBy((Path)it.getKey(), paths);
                }
            }).transform(new Function<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>, ListenerStateCapture<P, D, DCL>>(){

                public ListenerStateCapture<P, D, DCL> apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                    return new ListenerStateCapture((Path)it.getKey(), it.getValue(), AbstractDataBroker.this.createIsContainedPredicate((Path)it.getKey()));
                }
            }).toList();
        }
    }

    protected Predicate<P> createContainsPredicate(P key) {
        return new Predicate<P>((Path)key){
            final /* synthetic */ Path val$key;
            {
                this.val$key = path;
            }

            public boolean apply(P other) {
                return this.val$key.contains(other);
            }
        };
    }

    protected Predicate<P> createIsContainedPredicate(P key) {
        return new Predicate<P>((Path)key){
            final /* synthetic */ Path val$key;
            {
                this.val$key = path;
            }

            public boolean apply(P other) {
                return other.contains(this.val$key);
            }
        };
    }

    protected boolean isAffectedBy(P key, Set<P> paths) {
        Predicate<P> contains = this.createContainsPredicate(key);
        if (paths.contains(key)) {
            return true;
        }
        for (Path path : paths) {
            if (!contains.apply((Object)path)) continue;
            return true;
        }
        return false;
    }

    protected boolean isProbablyAffectedBy(P key, Set<P> paths) {
        Predicate<P> isContained = this.createIsContainedPredicate(key);
        for (Path path : paths) {
            if (!isContained.apply((Object)path)) continue;
            return true;
        }
        return false;
    }

    final Future<RpcResult<TransactionStatus>> commit(AbstractDataTransaction<P, D> transaction) {
        Preconditions.checkNotNull(transaction);
        TwoPhaseCommit task = new TwoPhaseCommit(transaction, this);
        this.getSubmittedTransactionsCount().getAndIncrement();
        return this.getExecutor().submit(task);
    }

    private static class DataCommitHandlerRegistrationImpl<P extends Path<P>, D>
    extends AbstractObjectRegistration<DataCommitHandler<P, D>>
    implements DataCommitHandlerRegistration<P, D> {
        private AbstractDataBroker<P, D, ? extends Object> dataBroker;
        private final P path;

        public P getPath() {
            return this.path;
        }

        public DataCommitHandlerRegistrationImpl(P path, DataCommitHandler<P, D> instance, AbstractDataBroker<P, D, ? extends Object> broker) {
            super(instance);
            this.dataBroker = broker;
            this.path = path;
        }

        protected void removeRegistration() {
            this.dataBroker.removeCommitHandler(this);
            this.dataBroker = null;
        }
    }
}

