/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLong;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.SkipTransactionsRequestV1;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

@Beta
public final class SkipTransactionsRequest
extends TransactionRequest<SkipTransactionsRequest> {
    private static final long serialVersionUID = 1L;
    private final @NonNull ImmutableList<UnsignedLong> others;

    public SkipTransactionsRequest(TransactionIdentifier target, long sequence, ActorRef replyTo, Collection<UnsignedLong> others) {
        super(target, sequence, replyTo);
        this.others = ImmutableList.copyOf(others);
    }

    public List<UnsignedLong> getOthers() {
        return this.others;
    }

    @Override
    protected SkipTransactionsRequestV1 externalizableProxy(ABIVersion version) {
        return new SkipTransactionsRequestV1(this);
    }

    @Override
    protected SkipTransactionsRequest cloneAsVersion(ABIVersion version) {
        return this;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        MoreObjects.ToStringHelper helper = super.addToStringAttributes(toStringHelper);
        if (!this.others.isEmpty()) {
            helper.add("others", this.others);
        }
        return helper;
    }
}

