/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.commands.AbstractTransactionRequestProxy;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;

final class ModifyTransactionRequestProxyV1
extends AbstractTransactionRequestProxy<ModifyTransactionRequest> {
    private static final long serialVersionUID = 1L;
    private List<TransactionModification> modifications;
    private Optional<PersistenceProtocol> protocol;
    private transient NormalizedNodeStreamVersion streamVersion;

    public ModifyTransactionRequestProxyV1() {
    }

    ModifyTransactionRequestProxyV1(ModifyTransactionRequest request) {
        super(request);
        this.modifications = Objects.requireNonNull(request.getModifications());
        this.protocol = request.getPersistenceProtocol();
        this.streamVersion = request.getVersion().getStreamVersion();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.protocol = Optional.ofNullable(PersistenceProtocol.readFrom(in));
        int size = in.readInt();
        if (size != 0) {
            this.modifications = new ArrayList<TransactionModification>(size);
            NormalizedNodeDataInput nnin = NormalizedNodeDataInput.newDataInput((DataInput)in);
            ReusableImmutableNormalizedNodeStreamWriter writer = ReusableImmutableNormalizedNodeStreamWriter.create();
            for (int i = 0; i < size; ++i) {
                this.modifications.add(TransactionModification.readFrom(nnin, (ReusableStreamReceiver)writer));
            }
        } else {
            this.modifications = ImmutableList.of();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(PersistenceProtocol.byteValue(this.protocol.orElse(null)));
        out.writeInt(this.modifications.size());
        if (!this.modifications.isEmpty()) {
            try (NormalizedNodeDataOutput nnout = this.streamVersion.newDataOutput((DataOutput)out);){
                for (TransactionModification op : this.modifications) {
                    op.writeTo(nnout);
                }
            }
        }
    }

    @Override
    protected ModifyTransactionRequest createRequest(TransactionIdentifier target, long sequence, ActorRef replyTo) {
        return new ModifyTransactionRequest(target, sequence, replyTo, this.modifications, this.protocol.orElse(null));
    }
}

