/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Identifiable;

@Beta
public final class ModifyTransactionRequestBuilder
implements Builder<ModifyTransactionRequest>,
Identifiable<TransactionIdentifier> {
    private final List<TransactionModification> modifications = new ArrayList<TransactionModification>(1);
    private final TransactionIdentifier identifier;
    private final ActorRef replyTo;
    private PersistenceProtocol protocol;
    private boolean haveSequence;
    private long sequence;

    public ModifyTransactionRequestBuilder(TransactionIdentifier identifier, ActorRef replyTo) {
        this.identifier = Objects.requireNonNull(identifier);
        this.replyTo = Objects.requireNonNull(replyTo);
    }

    public TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    private void checkNotFinished() {
        Preconditions.checkState((this.protocol == null ? 1 : 0) != 0, (Object)"Batch has already been finished");
    }

    public void addModification(TransactionModification modification) {
        this.checkNotFinished();
        this.modifications.add(Objects.requireNonNull(modification));
    }

    public void setSequence(long sequence) {
        Preconditions.checkState((!this.haveSequence ? 1 : 0) != 0, (Object)"Sequence has already been set");
        this.sequence = sequence;
        this.haveSequence = true;
    }

    public void setAbort() {
        this.checkNotFinished();
        this.modifications.clear();
        this.protocol = PersistenceProtocol.ABORT;
    }

    public void setCommit(boolean coordinated) {
        this.checkNotFinished();
        this.protocol = coordinated ? PersistenceProtocol.THREE_PHASE : PersistenceProtocol.SIMPLE;
    }

    public void setReady() {
        this.checkNotFinished();
        this.protocol = PersistenceProtocol.READY;
    }

    public int size() {
        return this.modifications.size();
    }

    public ModifyTransactionRequest build() {
        Preconditions.checkState((boolean)this.haveSequence, (Object)"Request sequence has not been set");
        ModifyTransactionRequest ret = new ModifyTransactionRequest(this.identifier, this.sequence, this.replyTo, this.modifications, this.protocol);
        this.modifications.clear();
        this.protocol = null;
        this.haveSequence = false;
        return ret;
    }
}

