/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetDomainConfigInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierGlobalCfg;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.BierGlobal;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetDomainConfigInputBuilder
implements Builder<SetDomainConfigInput> {
    private BierGlobal _bierGlobal;
    private Integer _domainId;
    private String _nodeName;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>> augmentation = Collections.emptyMap();

    public SetDomainConfigInputBuilder() {
    }

    public SetDomainConfigInputBuilder(BierGlobalCfg arg) {
        this._bierGlobal = arg.getBierGlobal();
    }

    public SetDomainConfigInputBuilder(SetDomainConfigInput base) {
        AugmentationHolder casted;
        this._bierGlobal = base.getBierGlobal();
        this._domainId = base.getDomainId();
        this._nodeName = base.getNodeName();
        this._writeType = base.getWriteType();
        if (base instanceof SetDomainConfigInputImpl) {
            SetDomainConfigInputImpl impl = (SetDomainConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BierGlobalCfg) {
            this._bierGlobal = ((BierGlobalCfg)arg).getBierGlobal();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierGlobalCfg] \nbut was: " + arg);
        }
    }

    public BierGlobal getBierGlobal() {
        return this._bierGlobal;
    }

    public Integer getDomainId() {
        return this._domainId;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetDomainConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetDomainConfigInputBuilder setBierGlobal(BierGlobal value) {
        this._bierGlobal = value;
        return this;
    }

    private static void checkDomainIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public SetDomainConfigInputBuilder setDomainId(Integer value) {
        if (value != null) {
            SetDomainConfigInputBuilder.checkDomainIdRange(value);
        }
        this._domainId = value;
        return this;
    }

    public SetDomainConfigInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    public SetDomainConfigInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetDomainConfigInputBuilder addAugmentation(Class<? extends Augmentation<SetDomainConfigInput>> augmentationType, Augmentation<SetDomainConfigInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetDomainConfigInputBuilder removeAugmentation(Class<? extends Augmentation<SetDomainConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetDomainConfigInput build() {
        return new SetDomainConfigInputImpl(this);
    }

    private static final class SetDomainConfigInputImpl
    implements SetDomainConfigInput {
        private final BierGlobal _bierGlobal;
        private final Integer _domainId;
        private final String _nodeName;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetDomainConfigInput> getImplementedInterface() {
            return SetDomainConfigInput.class;
        }

        private SetDomainConfigInputImpl(SetDomainConfigInputBuilder base) {
            this._bierGlobal = base.getBierGlobal();
            this._domainId = base.getDomainId();
            this._nodeName = base.getNodeName();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>>(base.augmentation);
                }
            }
        }

        public BierGlobal getBierGlobal() {
            return this._bierGlobal;
        }

        @Override
        public Integer getDomainId() {
            return this._domainId;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetDomainConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bierGlobal);
            result = 31 * result + Objects.hashCode(this._domainId);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetDomainConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetDomainConfigInput other = (SetDomainConfigInput)obj;
            if (!Objects.equals(this._bierGlobal, other.getBierGlobal())) {
                return false;
            }
            if (!Objects.equals(this._domainId, other.getDomainId())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetDomainConfigInputImpl otherImpl = (SetDomainConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetDomainConfigInput>>, Augmentation<SetDomainConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetDomainConfigInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bierGlobal != null) {
                builder.append("_bierGlobal=");
                builder.append(this._bierGlobal);
                builder.append(", ");
            }
            if (this._domainId != null) {
                builder.append("_domainId=");
                builder.append(this._domainId);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

