/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpAggregator;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AggregatorBuilder {
    private AsNumber _asNumber;
    private Ipv4Address _networkAddress;
    private Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>();

    public AggregatorBuilder() {
    }

    public AggregatorBuilder(BgpAggregator arg) {
        this._asNumber = arg.getAsNumber();
        this._networkAddress = arg.getNetworkAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpAggregator) {
            this._asNumber = ((BgpAggregator)arg).getAsNumber();
            this._networkAddress = ((BgpAggregator)arg).getNetworkAddress();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpAggregator] \nbut was: " + arg);
        }
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public Ipv4Address getNetworkAddress() {
        return this._networkAddress;
    }

    public <E extends Augmentation<Aggregator>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AggregatorBuilder setAsNumber(AsNumber value) {
        this._asNumber = value;
        return this;
    }

    public AggregatorBuilder setNetworkAddress(Ipv4Address value) {
        this._networkAddress = value;
        return this;
    }

    public AggregatorBuilder addAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType, Augmentation<Aggregator> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Aggregator build() {
        return new AggregatorImpl(this);
    }

    private static final class AggregatorImpl
    implements Aggregator {
        private final AsNumber _asNumber;
        private final Ipv4Address _networkAddress;
        private Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>();

        public Class<Aggregator> getImplementedInterface() {
            return Aggregator.class;
        }

        private AggregatorImpl(AggregatorBuilder builder) {
            this._asNumber = builder.getAsNumber();
            this._networkAddress = builder.getNetworkAddress();
            this.augmentation.putAll(builder.augmentation);
        }

        public AsNumber getAsNumber() {
            return this._asNumber;
        }

        public Ipv4Address getNetworkAddress() {
            return this._networkAddress;
        }

        public <E extends Augmentation<Aggregator>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._asNumber == null ? 0 : this._asNumber.hashCode());
            result = 31 * result + (this._networkAddress == null ? 0 : this._networkAddress.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AggregatorImpl other = (AggregatorImpl)obj;
            if (this._asNumber == null ? other._asNumber != null : !this._asNumber.equals((Object)other._asNumber)) {
                return false;
            }
            if (this._networkAddress == null ? other._networkAddress != null : !this._networkAddress.equals((Object)other._networkAddress)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Aggregator [_asNumber=");
            builder.append(this._asNumber);
            builder.append(", _networkAddress=");
            builder.append(this._networkAddress);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

