/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.WithdrawnRoutes;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class UpdateBuilder {
    private Nlri _nlri;
    private PathAttributes _pathAttributes;
    private WithdrawnRoutes _withdrawnRoutes;
    private Map<Class<? extends Augmentation<Update>>, Augmentation<Update>> augmentation = new HashMap<Class<? extends Augmentation<Update>>, Augmentation<Update>>();

    public Nlri getNlri() {
        return this._nlri;
    }

    public PathAttributes getPathAttributes() {
        return this._pathAttributes;
    }

    public WithdrawnRoutes getWithdrawnRoutes() {
        return this._withdrawnRoutes;
    }

    public <E extends Augmentation<Update>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateBuilder setNlri(Nlri value) {
        this._nlri = value;
        return this;
    }

    public UpdateBuilder setPathAttributes(PathAttributes value) {
        this._pathAttributes = value;
        return this;
    }

    public UpdateBuilder setWithdrawnRoutes(WithdrawnRoutes value) {
        this._withdrawnRoutes = value;
        return this;
    }

    public UpdateBuilder addAugmentation(Class<? extends Augmentation<Update>> augmentationType, Augmentation<Update> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Update build() {
        return new UpdateImpl(this);
    }

    private static final class UpdateImpl
    implements Update {
        private final Nlri _nlri;
        private final PathAttributes _pathAttributes;
        private final WithdrawnRoutes _withdrawnRoutes;
        private Map<Class<? extends Augmentation<Update>>, Augmentation<Update>> augmentation = new HashMap<Class<? extends Augmentation<Update>>, Augmentation<Update>>();

        public Class<Update> getImplementedInterface() {
            return Update.class;
        }

        private UpdateImpl(UpdateBuilder builder) {
            this._nlri = builder.getNlri();
            this._pathAttributes = builder.getPathAttributes();
            this._withdrawnRoutes = builder.getWithdrawnRoutes();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Nlri getNlri() {
            return this._nlri;
        }

        @Override
        public PathAttributes getPathAttributes() {
            return this._pathAttributes;
        }

        @Override
        public WithdrawnRoutes getWithdrawnRoutes() {
            return this._withdrawnRoutes;
        }

        public <E extends Augmentation<Update>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nlri == null ? 0 : this._nlri.hashCode());
            result = 31 * result + (this._pathAttributes == null ? 0 : this._pathAttributes.hashCode());
            result = 31 * result + (this._withdrawnRoutes == null ? 0 : this._withdrawnRoutes.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateImpl other = (UpdateImpl)obj;
            if (this._nlri == null ? other._nlri != null : !this._nlri.equals(other._nlri)) {
                return false;
            }
            if (this._pathAttributes == null ? other._pathAttributes != null : !this._pathAttributes.equals(other._pathAttributes)) {
                return false;
            }
            if (this._withdrawnRoutes == null ? other._withdrawnRoutes != null : !this._withdrawnRoutes.equals(other._withdrawnRoutes)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Update [_nlri=");
            builder.append(this._nlri);
            builder.append(", _pathAttributes=");
            builder.append(this._pathAttributes);
            builder.append(", _withdrawnRoutes=");
            builder.append(this._withdrawnRoutes);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

