/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParameters;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class OpenBuilder {
    private Ipv4Address _bgpIdentifier;
    private List<BgpParameters> _bgpParameters;
    private Integer _holdTimer;
    private Integer _myAsNumber;
    private ProtocolVersion _version;
    private Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();

    public Ipv4Address getBgpIdentifier() {
        return this._bgpIdentifier;
    }

    public List<BgpParameters> getBgpParameters() {
        return this._bgpParameters;
    }

    public Integer getHoldTimer() {
        return this._holdTimer;
    }

    public Integer getMyAsNumber() {
        return this._myAsNumber;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<Open>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenBuilder setBgpIdentifier(Ipv4Address value) {
        this._bgpIdentifier = value;
        return this;
    }

    public OpenBuilder setBgpParameters(List<BgpParameters> value) {
        this._bgpParameters = value;
        return this;
    }

    public OpenBuilder setHoldTimer(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._holdTimer = value;
        return this;
    }

    public OpenBuilder setMyAsNumber(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._myAsNumber = value;
        return this;
    }

    public OpenBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenBuilder addAugmentation(Class<? extends Augmentation<Open>> augmentationType, Augmentation<Open> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
    implements Open {
        private final Ipv4Address _bgpIdentifier;
        private final List<BgpParameters> _bgpParameters;
        private final Integer _holdTimer;
        private final Integer _myAsNumber;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();

        public Class<Open> getImplementedInterface() {
            return Open.class;
        }

        private OpenImpl(OpenBuilder builder) {
            this._bgpIdentifier = builder.getBgpIdentifier();
            this._bgpParameters = builder.getBgpParameters();
            this._holdTimer = builder.getHoldTimer();
            this._myAsNumber = builder.getMyAsNumber();
            this._version = builder.getVersion();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Ipv4Address getBgpIdentifier() {
            return this._bgpIdentifier;
        }

        @Override
        public List<BgpParameters> getBgpParameters() {
            return this._bgpParameters;
        }

        @Override
        public Integer getHoldTimer() {
            return this._holdTimer;
        }

        @Override
        public Integer getMyAsNumber() {
            return this._myAsNumber;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<Open>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bgpIdentifier == null ? 0 : this._bgpIdentifier.hashCode());
            result = 31 * result + (this._bgpParameters == null ? 0 : this._bgpParameters.hashCode());
            result = 31 * result + (this._holdTimer == null ? 0 : this._holdTimer.hashCode());
            result = 31 * result + (this._myAsNumber == null ? 0 : this._myAsNumber.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpenImpl other = (OpenImpl)obj;
            if (this._bgpIdentifier == null ? other._bgpIdentifier != null : !this._bgpIdentifier.equals((Object)other._bgpIdentifier)) {
                return false;
            }
            if (this._bgpParameters == null ? other._bgpParameters != null : !this._bgpParameters.equals(other._bgpParameters)) {
                return false;
            }
            if (this._holdTimer == null ? other._holdTimer != null : !this._holdTimer.equals(other._holdTimer)) {
                return false;
            }
            if (this._myAsNumber == null ? other._myAsNumber != null : !this._myAsNumber.equals(other._myAsNumber)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Open [_bgpIdentifier=");
            builder.append(this._bgpIdentifier);
            builder.append(", _bgpParameters=");
            builder.append(this._bgpParameters);
            builder.append(", _holdTimer=");
            builder.append(this._holdTimer);
            builder.append(", _myAsNumber=");
            builder.append(this._myAsNumber);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

