/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import com.google.common.base.Preconditions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;

public final class BgpTableTypeImpl
implements BgpTableType {
    private final Class<? extends SubsequentAddressFamily> safi;
    private final Class<? extends AddressFamily> afi;

    public BgpTableTypeImpl(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi) {
        this.afi = (Class)Preconditions.checkNotNull(afi, (Object)"Address family may not be null");
        this.safi = (Class)Preconditions.checkNotNull(safi, (Object)"Subsequent address family may not be null");
    }

    public Class<BgpTableType> getImplementedInterface() {
        return BgpTableType.class;
    }

    public int hashCode() {
        int ret = 3 * this.afi.hashCode();
        return ret += this.safi.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BgpTableTypeImpl) {
            BgpTableTypeImpl o = (BgpTableTypeImpl)obj;
            return this.afi.equals(o.afi) && this.safi.equals(o.safi);
        }
        return false;
    }

    public String toString() {
        return this.afi.toString() + "." + this.safi.toString();
    }

    @Override
    public Class<? extends AddressFamily> getAfi() {
        return this.afi;
    }

    @Override
    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this.safi;
    }
}

