/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

public enum BGPError {
    CONNECTION_NOT_SYNC(1, 1),
    BAD_MSG_LENGTH(1, 2),
    BAD_MSG_TYPE(1, 3),
    UNSPECIFIC_OPEN_ERROR(2, 0),
    VERSION_NOT_SUPPORTED(2, 1),
    BAD_PEER_AS(2, 2),
    BAD_BGP_ID(2, 3),
    OPT_PARAM_NOT_SUPPORTED(2, 4),
    HOLD_TIME_NOT_ACC(2, 6),
    MALFORMED_ATTR_LIST(3, 1),
    WELL_KNOWN_ATTR_NOT_RECOGNIZED(3, 2),
    WELL_KNOWN_ATTR_MISSING(3, 3),
    ATTR_FLAGS_MISSING(3, 4),
    ATTR_LENGTH_ERROR(3, 5),
    ORIGIN_ATTR_NOT_VALID(3, 6),
    NEXT_HOP_NOT_VALID(3, 8),
    OPT_ATTR_ERROR(3, 9),
    NETWORK_NOT_VALID(3, 10),
    AS_PATH_MALFORMED(3, 11),
    HOLD_TIMER_EXPIRED(4, 0),
    FSM_ERROR(5, 0),
    CEASE(6, 0);

    private final short code;
    private final short subcode;

    private BGPError(short code, short subcode) {
        this.code = code;
        this.subcode = subcode;
    }

    public short getCode() {
        return this.code;
    }

    public short getSubcode() {
        return this.subcode;
    }

    public static BGPError forValue(int e, int s) {
        if (e == 1) {
            if (s == 1) {
                return CONNECTION_NOT_SYNC;
            }
            if (s == 2) {
                return BAD_MSG_LENGTH;
            }
            if (s == 3) {
                return BAD_MSG_TYPE;
            }
        } else if (e == 2) {
            if (s == 0) {
                return UNSPECIFIC_OPEN_ERROR;
            }
            if (s == 1) {
                return VERSION_NOT_SUPPORTED;
            }
            if (s == 2) {
                return BAD_PEER_AS;
            }
            if (s == 3) {
                return BAD_BGP_ID;
            }
            if (s == 4) {
                return OPT_PARAM_NOT_SUPPORTED;
            }
            if (s == 6) {
                return HOLD_TIME_NOT_ACC;
            }
        } else if (e == 3) {
            if (s == 1) {
                return MALFORMED_ATTR_LIST;
            }
            if (s == 2) {
                return WELL_KNOWN_ATTR_NOT_RECOGNIZED;
            }
            if (s == 3) {
                return WELL_KNOWN_ATTR_MISSING;
            }
            if (s == 4) {
                return ATTR_FLAGS_MISSING;
            }
            if (s == 5) {
                return ATTR_LENGTH_ERROR;
            }
            if (s == 6) {
                return ORIGIN_ATTR_NOT_VALID;
            }
            if (s == 8) {
                return NEXT_HOP_NOT_VALID;
            }
            if (s == 9) {
                return OPT_ATTR_ERROR;
            }
            if (s == 10) {
                return NETWORK_NOT_VALID;
            }
            if (s == 11) {
                return AS_PATH_MALFORMED;
            }
        } else {
            if (e == 4) {
                return HOLD_TIMER_EXPIRED;
            }
            if (e == 5) {
                return FSM_ERROR;
            }
            if (e == 6) {
                return CEASE;
            }
        }
        throw new IllegalArgumentException("BGP Error code " + e + " and subcode " + s + " not recognized.");
    }
}

