/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPDocumentedException
extends Exception {
    private static final long serialVersionUID = -6212702584439430736L;
    private static final Logger LOG = LoggerFactory.getLogger(BGPDocumentedException.class);
    private final BGPError error;
    private final byte[] data;

    public BGPDocumentedException(String message, BGPError error) {
        this(message, error, null, null);
    }

    public BGPDocumentedException(String message, BGPError error, Exception cause) {
        this(message, error, null, cause);
    }

    public BGPDocumentedException(String message, BGPError error, byte[] data) {
        this(message, error, data, null);
    }

    public BGPDocumentedException(String message, BGPError error, byte[] data, Exception cause) {
        super(message, cause);
        this.error = error;
        this.data = data == null ? null : Arrays.copyOf(data, data.length);
        LOG.error("Error = {}", (Object)error, (Object)this);
    }

    public BGPError getError() {
        return this.error;
    }

    public byte[] getData() {
        return this.data;
    }

    public static BGPDocumentedException badMessageLength(String message, int length) {
        Preconditions.checkArgument((length >= 0 && length <= 65535 ? 1 : 0) != 0);
        return new BGPDocumentedException(message, BGPError.BAD_MSG_LENGTH, new byte[]{UnsignedBytes.checkedCast((long)(length / 256)), UnsignedBytes.checkedCast((long)(length % 256))});
    }
}

