/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class DynamodbPath
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(dependency={"region"}, prefix="tables")
    private final String table;
    @PathField(dependency={"table"}, prefix="columns")
    private final String column;

    @Override
    public String prefix() {
        return "//dynamodb/cloud/aws";
    }

    DynamodbPath(String account, String region, String table, String column) {
        this.account = account;
        this.region = region;
        this.table = table;
        this.column = column;
    }

    public static DynamodbPathBuilder builder() {
        return new DynamodbPathBuilder();
    }

    public DynamodbPathBuilder toBuilder() {
        return new DynamodbPathBuilder().account(this.account).region(this.region).table(this.table).column(this.column);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamodbPath)) {
            return false;
        }
        DynamodbPath other = (DynamodbPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamodbPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "DynamodbPath(account=" + this.getAccount() + ", region=" + this.getRegion() + ", table=" + this.getTable() + ", column=" + this.getColumn() + ")";
    }

    public static class DynamodbPathBuilder {
        private String account;
        private String region;
        private String table;
        private String column;

        DynamodbPathBuilder() {
        }

        public DynamodbPathBuilder account(String account) {
            this.account = account;
            return this;
        }

        public DynamodbPathBuilder region(String region) {
            this.region = region;
            return this;
        }

        public DynamodbPathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public DynamodbPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public DynamodbPath build() {
            return new DynamodbPath(this.account, this.region, this.table, this.column);
        }

        public String toString() {
            return "DynamodbPath.DynamodbPathBuilder(account=" + this.account + ", region=" + this.region + ", table=" + this.table + ", column=" + this.column + ")";
        }
    }
}

