/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class GrpcServicePath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(dependency={"host"}, prefix="services")
    private final String service;
    @PathField(dependency={"service"}, prefix="methods")
    private final String method;

    @Override
    public String prefix() {
        return "//grpc";
    }

    GrpcServicePath(String host, String service, String method) {
        this.host = host;
        this.service = service;
        this.method = method;
    }

    public static GrpcServicePathBuilder builder() {
        return new GrpcServicePathBuilder();
    }

    public GrpcServicePathBuilder toBuilder() {
        return new GrpcServicePathBuilder().host(this.host).service(this.service).method(this.method);
    }

    public String getHost() {
        return this.host;
    }

    public String getService() {
        return this.service;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcServicePath)) {
            return false;
        }
        GrpcServicePath other = (GrpcServicePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcServicePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "GrpcServicePath(host=" + this.getHost() + ", service=" + this.getService() + ", method=" + this.getMethod() + ")";
    }

    public static class GrpcServicePathBuilder {
        private String host;
        private String service;
        private String method;

        GrpcServicePathBuilder() {
        }

        public GrpcServicePathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public GrpcServicePathBuilder service(String service) {
            this.service = service;
            return this;
        }

        public GrpcServicePathBuilder method(String method) {
            this.method = method;
            return this;
        }

        public GrpcServicePath build() {
            return new GrpcServicePath(this.host, this.service, this.method);
        }

        public String toString() {
            return "GrpcServicePath.GrpcServicePathBuilder(host=" + this.host + ", service=" + this.service + ", method=" + this.method + ")";
        }
    }
}

