/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.opencds.cqf.cql.engine.exception.InvalidDateTime;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;

public class DateTime
extends BaseTemporal {
    private OffsetDateTime dateTime;

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        if (dateTime.getYear() < 1) {
            throw new InvalidDateTime(String.format("The year: %d falls below the accepted bounds of 0001-9999.", dateTime.getYear()));
        }
        if (dateTime.getYear() > 9999) {
            throw new InvalidDateTime(String.format("The year: %d falls above the accepted bounds of 0001-9999.", dateTime.getYear()));
        }
        this.dateTime = dateTime;
    }

    public DateTime withDateTime(OffsetDateTime dateTime) {
        this.setDateTime(dateTime);
        return this;
    }

    public DateTime withPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    public DateTime(OffsetDateTime dateTime) {
        this.setDateTime(dateTime);
        this.precision = Precision.MILLISECOND;
    }

    public DateTime(OffsetDateTime dateTime, Precision precision) {
        this.setDateTime(dateTime);
        this.precision = precision;
    }

    public DateTime(String dateString, ZoneOffset offset) {
        if (dateString.matches("T[0-2]\\d:[0-5]\\d:[0-5]\\d\\.\\d{3}(\\+|-)\\d{2}$")) {
            dateString = dateString + ":00";
        }
        int size = 0;
        boolean hasOffset = true;
        if (dateString.contains("T")) {
            String[] datetimeSplit = dateString.split("T");
            size += datetimeSplit[0].split("-").length;
            String[] tzSplit = dateString.contains("Z") ? dateString.split("Z") : datetimeSplit[1].split("[+-]");
            size += tzSplit[0].split(":").length;
            if (tzSplit[0].contains(".")) {
                ++size;
            }
            this.precision = Precision.fromDateTimeIndex(size - 1);
            if (tzSplit.length == 1 && !dateString.contains("Z")) {
                dateString = TemporalHelper.autoCompleteDateTimeString(dateString, this.precision);
                if (offset != null) {
                    dateString = dateString + offset.getId();
                } else {
                    hasOffset = false;
                }
            }
        } else {
            this.precision = Precision.fromDateTimeIndex((size += dateString.split("-").length) - 1);
            dateString = TemporalHelper.autoCompleteDateTimeString(dateString, this.precision);
            if (offset != null) {
                dateString = dateString + offset.getId();
            } else {
                hasOffset = false;
            }
        }
        if (hasOffset) {
            this.setDateTime(OffsetDateTime.parse(dateString));
        } else {
            this.setDateTime(TemporalHelper.toOffsetDateTime(LocalDateTime.parse(dateString)));
        }
    }

    public DateTime(BigDecimal offset, int ... dateElements) {
        if (dateElements.length == 0) {
            throw new InvalidDateTime("DateTime must include a year");
        }
        StringBuilder dateString = new StringBuilder();
        String[] stringElements = TemporalHelper.normalizeDateTimeElements(dateElements);
        for (int i = 0; i < stringElements.length; ++i) {
            if (i == 0) {
                dateString.append(stringElements[i]);
                continue;
            }
            if (i < 3) {
                dateString.append("-");
            } else if (i == 3) {
                dateString.append("T");
            } else if (i < 6) {
                dateString.append(":");
            } else if (i == 6) {
                dateString.append(".");
            }
            dateString.append(stringElements[i]);
        }
        this.precision = Precision.fromDateTimeIndex(stringElements.length - 1);
        dateString = new StringBuilder().append(TemporalHelper.autoCompleteDateTimeString(dateString.toString(), this.precision));
        if (offset != null) {
            dateString.append(ZoneOffset.ofHoursMinutes(offset.intValue(), new BigDecimal("60").multiply(offset.remainder(BigDecimal.ONE)).intValue()).getId());
            this.setDateTime(OffsetDateTime.parse(dateString.toString()));
        } else {
            this.setDateTime(TemporalHelper.toOffsetDateTime(LocalDateTime.parse(dateString.toString())));
        }
    }

    public DateTime expandPartialMinFromPrecision(Precision thePrecision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        for (int i = thePrecision.toDateTimeIndex() + 1; i < 7; ++i) {
            odt = odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMinimum());
        }
        return new DateTime(odt, this.precision);
    }

    public DateTime expandPartialMin(Precision thePrecision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        return new DateTime(odt, thePrecision == null ? Precision.MILLISECOND : thePrecision);
    }

    public DateTime expandPartialMax(Precision thePrecision) {
        OffsetDateTime odt = this.getDateTime().plusYears(0L);
        for (int i = this.getPrecision().toDateTimeIndex() + 1; i < 7; ++i) {
            odt = i <= thePrecision.toDateTimeIndex() ? odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMaximum()) : odt.with(Precision.fromDateTimeIndex(i).toChronoField(), odt.range(Precision.fromDateTimeIndex(i).toChronoField()).getMinimum());
        }
        return new DateTime(odt, thePrecision == null ? Precision.MILLISECOND : thePrecision);
    }

    @Override
    public boolean isUncertain(Precision thePrecision) {
        if (thePrecision == Precision.WEEK) {
            thePrecision = Precision.DAY;
        }
        return this.precision.toDateTimeIndex() < thePrecision.toDateTimeIndex();
    }

    @Override
    public Interval getUncertaintyInterval(Precision thePrecision) {
        DateTime start = this.expandPartialMin(thePrecision);
        DateTime end = this.expandPartialMax(thePrecision).expandPartialMinFromPrecision(thePrecision);
        return new Interval(start, true, end, true);
    }

    @Override
    public Integer compare(BaseTemporal other, boolean forSort) {
        boolean differentPrecisions;
        boolean bl = differentPrecisions = this.getPrecision() != other.getPrecision();
        if (differentPrecisions) {
            Integer result = this.compareToPrecision(other, Precision.getHighestDateTimePrecision(this.precision, other.precision));
            if (result == null && forSort) {
                return this.precision.toDateTimeIndex() > other.precision.toDateTimeIndex() ? 1 : -1;
            }
            return result;
        }
        return this.compareToPrecision(other, this.precision);
    }

    public OffsetDateTime getNormalized(Precision precision) {
        if (precision.toDateTimeIndex() > Precision.DAY.toDateTimeIndex()) {
            Context c = Context.getContext();
            if (c != null) {
                return this.dateTime.atZoneSameInstant(c.getEvaluationZonedDateTime().getZone()).toOffsetDateTime();
            }
            return this.dateTime.atZoneSameInstant(TimeZone.getDefault().toZoneId()).toOffsetDateTime();
        }
        return this.dateTime;
    }

    @Override
    public Integer compareToPrecision(BaseTemporal other, Precision thePrecision) {
        boolean leftMeetsPrecisionRequirements = this.precision.toDateTimeIndex() >= thePrecision.toDateTimeIndex();
        boolean rightMeetsPrecisionRequirements = other.precision.toDateTimeIndex() >= thePrecision.toDateTimeIndex();
        OffsetDateTime leftDateTime = this.getNormalized(thePrecision);
        OffsetDateTime rightDateTime = ((DateTime)other).getNormalized(thePrecision);
        if (!leftMeetsPrecisionRequirements || !rightMeetsPrecisionRequirements) {
            thePrecision = Precision.getLowestDateTimePrecision(this.precision, other.precision);
        }
        for (int i = 0; i < thePrecision.toDateTimeIndex() + 1; ++i) {
            int rightComp;
            int leftComp = leftDateTime.get(Precision.getDateTimeChronoFieldFromIndex(i));
            if (leftComp > (rightComp = rightDateTime.get(Precision.getDateTimeChronoFieldFromIndex(i)))) {
                return 1;
            }
            if (leftComp >= rightComp) continue;
            return -1;
        }
        if (leftMeetsPrecisionRequirements && rightMeetsPrecisionRequirements) {
            return 0;
        }
        return null;
    }

    @Override
    public int compareTo(@Nonnull BaseTemporal other) {
        return this.compare(other, true);
    }

    @Override
    public Boolean equivalent(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        return comparison != null && comparison == 0;
    }

    @Override
    public Boolean equal(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        return comparison == null ? null : Boolean.valueOf(comparison == 0);
    }

    public String toString() {
        switch (this.precision) {
            case YEAR: {
                return String.format("%04d", this.dateTime.getYear());
            }
            case MONTH: {
                return String.format("%04d-%02d", this.dateTime.getYear(), this.dateTime.getMonthValue());
            }
            case DAY: {
                return String.format("%04d-%02d-%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth());
            }
            case HOUR: {
                return String.format("%04d-%02d-%02dT%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour());
            }
            case MINUTE: {
                return String.format("%04d-%02d-%02dT%02d:%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute());
            }
            case SECOND: {
                return String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute(), this.dateTime.getSecond());
            }
        }
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d", this.dateTime.getYear(), this.dateTime.getMonthValue(), this.dateTime.getDayOfMonth(), this.dateTime.getHour(), this.dateTime.getMinute(), this.dateTime.getSecond(), this.dateTime.get(this.precision.toChronoField()));
    }

    public Date toJavaDate() {
        return Date.from(this.dateTime.toInstant());
    }

    public static DateTime fromJavaDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new DateTime(OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()), Precision.MILLISECOND);
    }
}

