/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Power;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class PowerEvaluator
extends Power {
    public static Object power(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer) {
            if ((Integer)right < 0) {
                return new BigDecimal(1).divide(new BigDecimal((Integer)left).pow(Math.abs((Integer)right)));
            }
            return new BigDecimal((Integer)left).pow((Integer)right).intValue();
        }
        if (left instanceof BigDecimal) {
            return Value.verifyPrecision(new BigDecimal(Math.pow(((BigDecimal)left).doubleValue(), ((BigDecimal)right).doubleValue())), null);
        }
        throw new InvalidOperatorArgument("Power(Integer, Integer) or Power(Decimal, Decimal)", String.format("Power(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return PowerEvaluator.power(left, right);
    }
}

