/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.OverlapsAfter;
import org.opencds.cqf.cql.engine.elm.execution.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class OverlapsAfterEvaluator
extends OverlapsAfter {
    public static Object overlapsAfter(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftEnd = ((Interval)left).getEnd();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftEnd instanceof BaseTemporal && rightEnd instanceof BaseTemporal) {
                return AndEvaluator.and(AfterEvaluator.after(leftEnd, rightEnd, precision), OverlapsEvaluator.overlaps(left, right, precision));
            }
            return AndEvaluator.and(GreaterEvaluator.greater(leftEnd, rightEnd), OverlapsEvaluator.overlaps(left, right, precision));
        }
        throw new InvalidOperatorArgument("OverlapsAfter(Interval<T>, Interval<T>)", String.format("Overlaps(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return OverlapsAfterEvaluator.overlapsAfter(left, right, precision);
    }
}

