/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import javax.xml.namespace.QName;
import org.cqframework.cql.elm.execution.MaxValue;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class MaxValueEvaluator
extends MaxValue {
    public static Object maxValue(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith("Integer")) {
            return Value.MAX_INT;
        }
        if (type.endsWith("Decimal")) {
            return Value.MAX_DECIMAL;
        }
        if (type.endsWith("Date")) {
            return new Date(9999, 12, 31);
        }
        if (type.endsWith("DateTime")) {
            return new DateTime(null, 9999, 12, 31, 23, 59, 59, 999);
        }
        if (type.endsWith("Time")) {
            return new Time(23, 59, 59, 999);
        }
        if (type.endsWith("Quantity")) {
            return new Quantity().withValue(Value.MAX_DECIMAL).withUnit("1");
        }
        throw new InvalidOperatorArgument(String.format("The Maximum operator is not implemented for type %s", type));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        QName valueType = context.fixupQName(this.getValueType());
        String type = valueType.getLocalPart();
        return MaxValueEvaluator.maxValue(type);
    }
}

