/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.stream.StreamSupport;
import org.cqframework.cql.elm.execution.Length;
import org.cqframework.cql.elm.execution.NamedTypeSpecifier;
import org.opencds.cqf.cql.engine.elm.execution.AsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class LengthEvaluator
extends Length {
    public static Object length(Object operand) {
        if (operand instanceof String) {
            return LengthEvaluator.stringLength((String)operand);
        }
        if (operand instanceof Iterable) {
            return LengthEvaluator.listLength((Iterable)operand);
        }
        throw new InvalidOperatorArgument("Length(List<T>) or Length(String)", String.format("Length(%s)", operand.getClass().getName()));
    }

    public static Integer stringLength(String operand) {
        if (operand == null) {
            return null;
        }
        return operand.length();
    }

    public static Integer listLength(Iterable<?> operand) {
        if (operand == null) {
            return 0;
        }
        return (int)StreamSupport.stream(operand.spliterator(), false).count();
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        if (this.getOperand() instanceof AsEvaluator) {
            if (((AsEvaluator)this.getOperand()).getAsTypeSpecifier() instanceof NamedTypeSpecifier) {
                return LengthEvaluator.stringLength((String)operand);
            }
            return LengthEvaluator.listLength((Iterable)operand);
        }
        return LengthEvaluator.length(operand);
    }
}

