/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.Arrays;
import org.cqframework.cql.elm.execution.IncludedIn;
import org.opencds.cqf.cql.engine.elm.execution.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class IncludedInEvaluator
extends IncludedIn {
    public static Boolean includedIn(Object left, Object right, String precision) {
        if (left instanceof Interval && right instanceof Interval) {
            return IncludedInEvaluator.intervalIncludedIn((Interval)left, (Interval)right, precision);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return IncludedInEvaluator.listIncludedIn((Iterable)left, (Iterable)right);
        }
        throw new InvalidOperatorArgument("IncludedIn(Interval<T>, Interval<T>), IncludedIn(List<T>, List<T>) or IncludedIn(T, List<T>)", String.format("IncludedIn(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean intervalIncludedIn(Interval left, Interval right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        Object leftStart = left.getStart();
        Object leftEnd = left.getEnd();
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        Boolean boundaryCheck = AndEvaluator.and(InEvaluator.in(leftStart, right, precision), InEvaluator.in(leftEnd, right, precision));
        if (boundaryCheck != null && boundaryCheck.booleanValue()) {
            return true;
        }
        if (leftStart instanceof BaseTemporal || leftEnd instanceof BaseTemporal || rightStart instanceof BaseTemporal || rightEnd instanceof BaseTemporal) {
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(BeforeEvaluator.before(leftStart, rightStart, precision), AfterEvaluator.after(leftEnd, rightEnd, precision))).booleanValue()) {
                return false;
            }
            return AndEvaluator.and(SameOrAfterEvaluator.sameOrAfter(leftStart, rightStart, precision), SameOrBeforeEvaluator.sameOrBefore(leftEnd, rightEnd, precision));
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(LessEvaluator.less(leftStart, rightStart), GreaterEvaluator.greater(leftEnd, rightEnd))).booleanValue()) {
            return false;
        }
        return AndEvaluator.and(GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart), LessOrEqualEvaluator.lessOrEqual(leftEnd, rightEnd));
    }

    public static Boolean listIncludedIn(Iterable<?> left, Iterable<?> right) {
        if (left == null) {
            return true;
        }
        if (right == null) {
            return false;
        }
        for (Object element : left) {
            Boolean in = InEvaluator.in(element, right, null);
            if (in == null || in.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object internalEvaluate(Context context) {
        String precision;
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String string = precision = this.getPrecision() != null ? this.getPrecision().value() : null;
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right instanceof Interval ? IncludedInEvaluator.intervalIncludedIn(null, (Interval)right, precision) : IncludedInEvaluator.listIncludedIn(null, (Iterable)right);
        }
        if (right == null) {
            return left instanceof Interval ? IncludedInEvaluator.intervalIncludedIn((Interval)left, null, precision) : IncludedInEvaluator.listIncludedIn((Iterable)left, null);
        }
        return IncludedInEvaluator.includedIn(left, right, precision);
    }
}

