/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.cqframework.cql.elm.execution.Collapse;
import org.opencds.cqf.cql.engine.elm.execution.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MeetsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class CollapseEvaluator
extends Collapse {
    private static Interval getIntervalWithPerApplied(Interval interval, Quantity per) {
        if (per.getValue().equals(new BigDecimal("0"))) {
            return interval;
        }
        if (interval.getPointType().getTypeName().contains("Integer")) {
            return new Interval(interval.getStart(), true, AddEvaluator.add(interval.getEnd(), per.getValue().intValue()), true);
        }
        if (interval.getPointType().getTypeName().contains("BigDecimal")) {
            return new Interval(interval.getStart(), true, AddEvaluator.add(interval.getEnd(), per.getValue()), true);
        }
        return new Interval(interval.getStart(), true, AddEvaluator.add(interval.getEnd(), per), true);
    }

    public static List<Interval> collapse(Iterable<Interval> list, Quantity per) {
        if (list == null) {
            return null;
        }
        List<Interval> intervals = CqlList.toList(list, false);
        if (intervals.size() == 1 || intervals.isEmpty()) {
            return intervals;
        }
        boolean isTemporal = intervals.get(0).getStart() instanceof BaseTemporal || intervals.get(0).getEnd() instanceof BaseTemporal;
        intervals.sort(new CqlList().valueSort);
        if (per == null) {
            per = new Quantity().withValue(new BigDecimal(0)).withDefaultUnit();
        }
        String precision = per.getUnit().equals("1") ? null : per.getUnit();
        for (int i = 0; i < intervals.size() - 1; ++i) {
            Interval applyPer = CollapseEvaluator.getIntervalWithPerApplied(intervals.get(i), per);
            Boolean doMerge = AnyTrueEvaluator.anyTrue(Arrays.asList(OverlapsEvaluator.overlaps(applyPer, intervals.get(i + 1), precision), MeetsEvaluator.meets(applyPer, intervals.get(i + 1), precision)));
            if (doMerge == null || !doMerge.booleanValue()) continue;
            Boolean isNextEndGreater = isTemporal ? AfterEvaluator.after(intervals.get(i + 1).getEnd(), applyPer.getEnd(), precision) : GreaterEvaluator.greater(intervals.get(i + 1).getEnd(), applyPer.getEnd());
            intervals.set(i, new Interval(applyPer.getStart(), true, isNextEndGreater != null && isNextEndGreater != false ? intervals.get(i + 1).getEnd() : applyPer.getEnd(), true));
            intervals.remove(i + 1);
            --i;
        }
        return intervals;
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Iterable list = (Iterable)this.getOperand().get(0).evaluate(context);
        Quantity per = (Quantity)this.getOperand().get(1).evaluate(context);
        return CollapseEvaluator.collapse(list, per);
    }
}

