/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Add;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class AddEvaluator
extends Add {
    public static Object add(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left + (Integer)right;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return Value.verifyPrecision(((BigDecimal)left).add((BigDecimal)right), null);
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            return new Quantity().withValue(((Quantity)left).getValue().add(((Quantity)right).getValue())).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof BaseTemporal && right instanceof Quantity) {
            Precision precision = Precision.fromString(((Quantity)right).getUnit());
            int valueToAdd = ((Quantity)right).getValue().intValue();
            if (left instanceof DateTime) {
                if (precision == Precision.WEEK) {
                    valueToAdd = TemporalHelper.weeksToDays(valueToAdd);
                    precision = Precision.DAY;
                }
                return new DateTime(((DateTime)left).getDateTime().plus(valueToAdd, precision.toChronoUnit()), ((DateTime)left).getPrecision());
            }
            if (left instanceof Date) {
                if (precision == Precision.WEEK) {
                    valueToAdd = TemporalHelper.weeksToDays(valueToAdd);
                    precision = Precision.DAY;
                }
                return new Date(((Date)left).getDate().plus(valueToAdd, precision.toChronoUnit())).setPrecision(((Date)left).getPrecision());
            }
            return new Time(((Time)left).getTime().plus(valueToAdd, precision.toChronoUnit()), ((Time)left).getPrecision());
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(AddEvaluator.add(leftInterval.getStart(), rightInterval.getStart()), true, AddEvaluator.add(leftInterval.getEnd(), rightInterval.getEnd()), true);
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).concat((String)right);
        }
        throw new InvalidOperatorArgument("Add(Integer, Integer), Add(Decimal, Decimal), Add(Quantity, Quantity), Add(Date, Quantity), Add(DateTime, Quantity) or Add(Time, Quantity)", String.format("Add(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return AddEvaluator.add(left, right);
    }
}

